/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.actions.AnnotateRevisionAction;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnnotatePreviousRevisionAction
extends AnnotateRevisionAction {
    @Nullable
    private final List<VcsFileRevision> myRevisions;

    public AnnotatePreviousRevisionAction(@NotNull FileAnnotation annotation, @NotNull AbstractVcs vcs) {
        int i;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/openapi/vcs/actions/AnnotatePreviousRevisionAction", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotatePreviousRevisionAction", "<init>"));
        }
        super("Annotate Previous Revision", "Annotate successor of selected revision in new tab", AllIcons.Actions.Annotate, annotation, vcs);
        List revisions = annotation.getRevisions();
        if (revisions == null) {
            this.myRevisions = null;
            return;
        }
        HashMap map = new HashMap();
        for (i = 0; i < revisions.size(); ++i) {
            VcsFileRevision revision = (VcsFileRevision)revisions.get(i);
            VcsFileRevision previousRevision = i + 1 < revisions.size() ? (VcsFileRevision)revisions.get(i + 1) : null;
            map.put(revision.getRevisionNumber(), previousRevision);
        }
        this.myRevisions = new ArrayList<VcsFileRevision>(annotation.getLineCount());
        for (i = 0; i < annotation.getLineCount(); ++i) {
            this.myRevisions.add((VcsFileRevision)map.get(annotation.getLineRevisionNumber(i)));
        }
    }

    @Override
    @Nullable
    public List<VcsFileRevision> getRevisions() {
        return this.myRevisions;
    }
}

