/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractMissingFilesAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        List files = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        boolean enabled = files != null && !files.isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final List files = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        if (files == null) {
            return;
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        final Runnable action = new Runnable(){

            @Override
            public void run() {
                final ArrayList allExceptions = new ArrayList();
                ChangesUtil.processFilePathsByVcs((Project)project, (Collection)files, (ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<FilePath>(){

                    public void process(AbstractVcs vcs, List<FilePath> items) {
                        List<VcsException> exceptions = AbstractMissingFilesAction.this.processFiles(vcs, files);
                        if (exceptions != null) {
                            allExceptions.addAll(exceptions);
                        }
                    }
                });
                for (FilePath file2 : files) {
                    VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file2);
                }
                ChangesViewManager.getInstance(project).scheduleRefresh();
                if (allExceptions.size() > 0) {
                    AbstractVcsHelper.getInstance((Project)project).showErrors(allExceptions, "VCS Errors");
                }
            }
        };
        if (this.synchronously()) {
            action.run();
        } else {
            progressManager.runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)action);
                }
            }, this.getName(), true, project);
        }
    }

    protected abstract boolean synchronously();

    protected abstract String getName();

    protected abstract List<VcsException> processFiles(AbstractVcs var1, List<FilePath> var2);
}

