/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.IgnoreUnversionedDialog;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Iterator;
import java.util.List;

public class IgnoreUnversionedAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        List files = (List)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
        if (files == null) {
            return;
        }
        IgnoreUnversionedAction.removeNullFiles(files);
        if (files.isEmpty()) {
            return;
        }
        IgnoreUnversionedDialog.ignoreSelectedFiles(project, files);
    }

    private static void removeNullFiles(List<VirtualFile> files) {
        Iterator<VirtualFile> iterator = files.iterator();
        while (iterator.hasNext()) {
            VirtualFile next = iterator.next();
            if (next != null) continue;
            iterator.remove();
        }
    }

    public void update(AnActionEvent e) {
        List files = (List)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
        if (files != null) {
            IgnoreUnversionedAction.removeNullFiles(files);
        }
        boolean enabled = files != null && !files.isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }
}

