/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.vcsUtil.RollbackUtil;
import java.util.Arrays;

public class RollbackDialogAction
extends AnAction
implements DumbAware {
    public RollbackDialogAction() {
        super(VcsBundle.message((String)"changes.action.rollback.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.rollback.description", (Object[])new Object[0]), AllIcons.Actions.Rollback);
    }

    public void actionPerformed(AnActionEvent e) {
        FileDocumentManager.getInstance().saveAllDocuments();
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final ChangesBrowser browser = (ChangesBrowser)e.getData(ChangesBrowser.DATA_KEY);
        if (browser != null) {
            browser.setDataIsDirty(true);
        }
        RollbackChangesDialog.rollbackChanges(project, Arrays.asList(changes), true, new Runnable(){

            @Override
            public void run() {
                if (browser != null) {
                    browser.rebuildList();
                    browser.setDataIsDirty(false);
                }
            }
        });
    }

    public void update(AnActionEvent e) {
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean enabled = changes != null && project != null;
        e.getPresentation().setEnabled(enabled);
        if (enabled) {
            String operationName = RollbackUtil.getRollbackOperationName(project);
            e.getPresentation().setText(operationName);
            e.getPresentation().setDescription(operationName + " selected changes");
        }
    }
}

