/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesAdapter;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.DateFormatUtil;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutdatedVersionNotifier
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.committed.OutdatedVersionNotifier");
    private final FileEditorManager myFileEditorManager;
    private final CommittedChangesCache myCache;
    private final Project myProject;
    private static final Key<OutdatedRevisionPanel> PANEL_KEY = new Key("OutdatedRevisionPanel");
    private volatile boolean myIncomingChangesRequested;

    public OutdatedVersionNotifier(FileEditorManager fileEditorManager, CommittedChangesCache cache, MessageBus messageBus, Project project) {
        this.myFileEditorManager = fileEditorManager;
        this.myCache = cache;
        this.myProject = project;
        messageBus.connect().subscribe(CommittedChangesCache.COMMITTED_TOPIC, (Object)new CommittedChangesAdapter(){

            @Override
            public void incomingChangesUpdated(@Nullable List<CommittedChangeList> receivedChanges) {
                if (OutdatedVersionNotifier.this.myCache.getCachedIncomingChanges() == null) {
                    OutdatedVersionNotifier.this.requestLoadIncomingChanges();
                } else {
                    OutdatedVersionNotifier.this.updateAllEditorsLater();
                }
            }

            @Override
            public void changesCleared() {
                OutdatedVersionNotifier.this.updateAllEditorsLater();
            }
        });
    }

    private void requestLoadIncomingChanges() {
        OutdatedVersionNotifier.debug("Requesting load of incoming changes");
        if (!this.myIncomingChangesRequested) {
            this.myIncomingChangesRequested = true;
            this.myCache.loadIncomingChangesAsync(new Consumer<List<CommittedChangeList>>(){

                public void consume(List<CommittedChangeList> committedChangeLists) {
                    OutdatedVersionNotifier.this.myIncomingChangesRequested = false;
                    OutdatedVersionNotifier.this.updateAllEditorsLater();
                }
            }, true);
        }
    }

    private static void debug(@NonNls String message) {
        LOG.debug(message);
    }

    public void projectOpened() {
        MyFileEditorManagerListener myFileEditorManagerListener = new MyFileEditorManagerListener();
        this.myFileEditorManager.addFileEditorManagerListener((FileEditorManagerListener)myFileEditorManagerListener, (Disposable)this.myProject);
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("OutdatedVersionNotifier" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/OutdatedVersionNotifier", "getComponentName"));
        }
        return "OutdatedVersionNotifier";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private void updateAllEditorsLater() {
        OutdatedVersionNotifier.debug("Queueing update of editors");
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                OutdatedVersionNotifier.this.updateAllEditors();
            }
        }, this.myProject.getDisposed());
    }

    private void updateAllEditors() {
        VirtualFile[] files;
        if (this.myCache.getCachedIncomingChanges() == null) {
            this.requestLoadIncomingChanges();
            return;
        }
        OutdatedVersionNotifier.debug("Updating editors");
        for (VirtualFile file2 : files = this.myFileEditorManager.getOpenFiles()) {
            FileEditor[] fileEditors;
            Pair<CommittedChangeList, Change> pair = this.myCache.getIncomingChangeList(file2);
            for (FileEditor editor : fileEditors = this.myFileEditorManager.getEditors(file2)) {
                OutdatedRevisionPanel oldPanel = (OutdatedRevisionPanel)((Object)editor.getUserData(PANEL_KEY));
                if (pair != null) {
                    if (oldPanel != null) {
                        oldPanel.setChangeList((CommittedChangeList)pair.first, (Change)pair.second);
                        continue;
                    }
                    this.initPanel((CommittedChangeList)pair.first, (Change)pair.second, editor);
                    continue;
                }
                if (oldPanel == null) continue;
                this.myFileEditorManager.removeTopComponent(editor, (JComponent)((Object)oldPanel));
                editor.putUserData(PANEL_KEY, null);
            }
        }
    }

    private void initPanel(CommittedChangeList list, Change c, FileEditor editor) {
        if (!OutdatedVersionNotifier.isIncomingChangesSupported(list)) {
            return;
        }
        OutdatedRevisionPanel component = new OutdatedRevisionPanel(list, c);
        editor.putUserData(PANEL_KEY, (Object)component);
        this.myFileEditorManager.addTopComponent(editor, (JComponent)((Object)component));
    }

    private static boolean isIncomingChangesSupported(@NotNull CommittedChangeList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/committed/OutdatedVersionNotifier", "isIncomingChangesSupported"));
        }
        CachingCommittedChangesProvider provider = list.getVcs().getCachingCommittedChangesProvider();
        return provider != null && provider.supportsIncomingChanges();
    }

    private static class OutdatedRevisionPanel
    extends EditorNotificationPanel {
        private CommittedChangeList myChangeList;

        public OutdatedRevisionPanel(CommittedChangeList changeList, Change c) {
            this.createActionLabel(VcsBundle.message((String)"outdated.version.show.diff.action", (Object[])new Object[0]), "Compare.LastVersion");
            this.createActionLabel(VcsBundle.message((String)"outdated.version.update.project.action", (Object[])new Object[0]), "Vcs.UpdateProject");
            this.myChangeList = changeList;
            this.updateLabelText(c);
        }

        private void updateLabelText(Change c) {
            String formattedDate;
            boolean dateIsPretty;
            String comment = this.myChangeList.getComment();
            int pos = comment.indexOf("\n");
            if (pos >= 0) {
                comment = comment.substring(0, pos).trim() + "...";
            }
            boolean bl = dateIsPretty = !(formattedDate = DateFormatUtil.formatPrettyDateTime((Date)this.myChangeList.getCommitDate())).contains("/");
            String key = c.getType() == Change.Type.DELETED ? "outdated.version.text.deleted" : (dateIsPretty ? "outdated.version.pretty.date.text" : "outdated.version.text");
            this.myLabel.setText(VcsBundle.message((String)key, (Object[])new Object[]{this.myChangeList.getCommitterName(), formattedDate, comment}));
        }

        public void setChangeList(CommittedChangeList changeList, Change c) {
            this.myChangeList = changeList;
            this.updateLabelText(c);
        }
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/vcs/changes/committed/OutdatedVersionNotifier$MyFileEditorManagerListener", "fileOpened"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/committed/OutdatedVersionNotifier$MyFileEditorManagerListener", "fileOpened"));
            }
            if (OutdatedVersionNotifier.this.myCache.getCachedIncomingChanges() == null) {
                OutdatedVersionNotifier.this.requestLoadIncomingChanges();
            } else {
                Pair<CommittedChangeList, Change> pair = OutdatedVersionNotifier.this.myCache.getIncomingChangeList(file2);
                if (pair != null) {
                    FileEditor[] fileEditors;
                    for (FileEditor editor : fileEditors = source.getEditors(file2)) {
                        OutdatedVersionNotifier.this.initPanel((CommittedChangeList)pair.first, (Change)pair.second, editor);
                    }
                }
            }
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/vcs/changes/committed/OutdatedVersionNotifier$MyFileEditorManagerListener", "fileClosed"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/committed/OutdatedVersionNotifier$MyFileEditorManagerListener", "fileClosed"));
            }
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/committed/OutdatedVersionNotifier$MyFileEditorManagerListener", "selectionChanged"));
            }
        }
    }
}

