/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.diff.DiffContentFactoryImpl;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.WaitForProgressToShow;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsHistoryUtil {
    public static Key<VcsFileRevision[]> REVISIONS_KEY = Key.create((String)"VcsHistoryUtil.Change");
    private static final Logger LOG = Logger.getInstance(VcsHistoryUtil.class);

    private VcsHistoryUtil() {
    }

    public static int compare(VcsFileRevision first, VcsFileRevision second) {
        if (first instanceof CurrentRevision && second instanceof CurrentRevision) {
            return VcsHistoryUtil.compareNumbers(first, second);
        }
        if (second instanceof CurrentRevision) {
            return -1 * VcsHistoryUtil.compare(second, first);
        }
        if (first instanceof CurrentRevision) {
            int result2 = VcsHistoryUtil.compareNumbers(first, second);
            if (result2 == 0) {
                return 1;
            }
            return result2;
        }
        return VcsHistoryUtil.compareNumbers(first, second);
    }

    public static int compareNumbers(VcsFileRevision first, VcsFileRevision second) {
        return first.getRevisionNumber().compareTo((Object)second.getRevisionNumber());
    }

    public static void showDiff(final @NotNull Project project, @NotNull FilePath path, @NotNull VcsFileRevision revision1, @NotNull VcsFileRevision revision2, @NotNull String title1, @NotNull String title2) throws VcsException, IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "showDiff"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "showDiff"));
        }
        if (revision1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision1", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "showDiff"));
        }
        if (revision2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision2", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "showDiff"));
        }
        if (title1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title1", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "showDiff"));
        }
        if (title2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title2", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "showDiff"));
        }
        byte[] content1 = VcsHistoryUtil.loadRevisionContent(revision1);
        byte[] content2 = VcsHistoryUtil.loadRevisionContent(revision2);
        String title = DiffRequestFactoryImpl.getContentTitle(path);
        DiffContent diffContent1 = VcsHistoryUtil.createContent(project, content1, revision1, path);
        DiffContent diffContent2 = VcsHistoryUtil.createContent(project, content2, revision2, path);
        SimpleDiffRequest request = new SimpleDiffRequest(title, diffContent1, diffContent2, title1, title2);
        request.putUserData(REVISIONS_KEY, (Object)new VcsFileRevision[]{revision1, revision2});
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable((DiffRequest)request){
            final /* synthetic */ DiffRequest val$request;
            {
                this.val$request = diffRequest;
            }

            @Override
            public void run() {
                DiffManager.getInstance().showDiff(project, this.val$request);
            }
        }, null, (Project)project);
    }

    @NotNull
    public static byte[] loadRevisionContent(@NotNull VcsFileRevision revision) throws VcsException, IOException {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "loadRevisionContent"));
        }
        byte[] content = revision.getContent();
        if (content == null) {
            revision.loadContent();
            content = revision.getContent();
        }
        if (content == null) {
            throw new VcsException("Failed to load content for revision " + revision.getRevisionNumber().asString());
        }
        if (content == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "loadRevisionContent"));
        }
        return content;
    }

    public static String loadRevisionContentGuessEncoding(@NotNull VcsFileRevision revision, @Nullable VirtualFile file2, @Nullable Project project) throws VcsException, IOException {
        EncodingProjectManager e;
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "loadRevisionContentGuessEncoding"));
        }
        byte[] bytes = VcsHistoryUtil.loadRevisionContent(revision);
        if (file2 != null) {
            return new String(bytes, file2.getCharset());
        }
        EncodingProjectManager encodingProjectManager = e = project != null ? EncodingProjectManager.getInstance((Project)project) : null;
        if (e == null) {
            e = EncodingManager.getInstance();
        }
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)e.getDefaultCharset());
    }

    @NotNull
    private static DiffContent createContent(@NotNull Project project, @NotNull byte[] content, @NotNull VcsFileRevision revision, @NotNull FilePath filePath) throws IOException {
        VirtualFile file2;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "createContent"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "createContent"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "createContent"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "createContent"));
        }
        DiffContentFactoryImpl contentFactory = DiffContentFactoryImpl.getInstanceImpl();
        if (VcsHistoryUtil.isCurrent(revision) && (file2 = filePath.getVirtualFile()) != null) {
            DiffContent diffContent = contentFactory.create(project, file2);
            if (diffContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "createContent"));
            }
            return diffContent;
        }
        if (VcsHistoryUtil.isEmpty(revision)) {
            EmptyContent emptyContent = contentFactory.createEmpty();
            if (emptyContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "createContent"));
            }
            return emptyContent;
        }
        DiffContent diffContent = contentFactory.createFromBytes(project, filePath, content);
        if (diffContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "createContent"));
        }
        return diffContent;
    }

    private static boolean isCurrent(VcsFileRevision revision) {
        return revision instanceof CurrentRevision;
    }

    private static boolean isEmpty(VcsFileRevision revision) {
        return revision == null || VcsFileRevision.NULL.equals(revision);
    }

    public static void showDifferencesInBackground(final @NotNull Project project, final @NotNull FilePath filePath, final @NotNull VcsFileRevision older, final @NotNull VcsFileRevision newer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "showDifferencesInBackground"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "showDifferencesInBackground"));
        }
        if (older == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "older", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "showDifferencesInBackground"));
        }
        if (newer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newer", "com/intellij/openapi/vcs/history/VcsHistoryUtil", "showDifferencesInBackground"));
        }
        new Task.Backgroundable(project, "Comparing Revisions..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/history/VcsHistoryUtil$2", "run"));
                }
                try {
                    VcsHistoryUtil.showDiff(project, filePath, older, newer, this.makeTitle(older), this.makeTitle(newer));
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                    WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((String)VcsBundle.message((String)"message.text.cannot.show.differences", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.show.differences", (Object[])new Object[0]));
                        }
                    }, null, (Project)project);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }

            @NotNull
            private String makeTitle(@NotNull VcsFileRevision revision) {
                if (revision == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/history/VcsHistoryUtil$2", "makeTitle"));
                }
                String string = revision.getRevisionNumber().asString() + (revision instanceof CurrentRevision ? " (" + VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]) + ")" : "");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/VcsHistoryUtil$2", "makeTitle"));
                }
                return string;
            }
        }.queue();
    }
}

