/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import org.jetbrains.annotations.NotNull;

public abstract class VirtualFileUrlChangeAdapter
extends VirtualFileAdapter {
    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/VirtualFileUrlChangeAdapter", "fileMoved"));
        }
        String oldUrl = event.getOldParent().getUrl() + "/" + event.getFileName();
        String newUrl = event.getNewParent().getUrl() + "/" + event.getFileName();
        this.fileUrlChanged(oldUrl, newUrl);
    }

    protected abstract void fileUrlChanged(String var1, String var2);

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        VirtualFile parent;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/VirtualFileUrlChangeAdapter", "propertyChanged"));
        }
        if ("name".equals(event.getPropertyName()) && (parent = event.getFile().getParent()) != null) {
            String parentUrl = parent.getUrl();
            this.fileUrlChanged(parentUrl + "/" + event.getOldValue(), parentUrl + "/" + event.getNewValue());
        }
    }
}

