/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.ex;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.Nullable;

public class LayoutFocusTraversalPolicyExt
extends LayoutFocusTraversalPolicy {
    private static JComponent myOverridenDefaultComponent;
    private boolean myNoDefaultComponent;
    private Object myNoDefaultComponentRequestor;
    private boolean myQueryImpl = false;

    public void setNoDefaultComponent(boolean noDefaultComponent, Object requestor) {
        if (noDefaultComponent) {
            this.myNoDefaultComponent = noDefaultComponent;
            this.myNoDefaultComponentRequestor = requestor;
        } else if (this.myNoDefaultComponentRequestor == requestor) {
            this.myNoDefaultComponent = false;
            this.myNoDefaultComponentRequestor = null;
        }
    }

    public boolean isNoDefaultComponent() {
        if (this.myQueryImpl) {
            return false;
        }
        return this.myNoDefaultComponent || Registry.is((String)"actionSystem.noDefaultComponent");
    }

    @Nullable
    public static LayoutFocusTraversalPolicyExt findWindowPolicy(Component c) {
        Window wnd = UIUtil.getWindow((Component)c);
        FocusTraversalPolicy policy = wnd.getFocusTraversalPolicy();
        if (policy instanceof LayoutFocusTraversalPolicyExt) {
            return (LayoutFocusTraversalPolicyExt)policy;
        }
        return null;
    }

    public static void setOverridenDefaultComponent(JComponent overridenDefaultComponent) {
        myOverridenDefaultComponent = overridenDefaultComponent;
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        if (this.isNoDefaultComponent()) {
            return null;
        }
        if (myOverridenDefaultComponent != null) {
            return myOverridenDefaultComponent;
        }
        return this.getDefaultComponentImpl(focusCycleRoot);
    }

    protected Component getDefaultComponentImpl(Container focusCycleRoot) {
        return super.getDefaultComponent(focusCycleRoot);
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        if (myOverridenDefaultComponent != null) {
            return myOverridenDefaultComponent;
        }
        return this.getFirstComponentImpl(focusCycleRoot);
    }

    protected Component getFirstComponentImpl(Container focusCycleRoot) {
        return super.getFirstComponent(focusCycleRoot);
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        if (myOverridenDefaultComponent != null) {
            return myOverridenDefaultComponent;
        }
        return this.getLastComponentImpl(focusCycleRoot);
    }

    protected Component getLastComponentImpl(Container focusCycleRoot) {
        return super.getLastComponent(focusCycleRoot);
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        if (myOverridenDefaultComponent != null) {
            return myOverridenDefaultComponent;
        }
        return this.getComponentAfterImpl(focusCycleRoot, aComponent);
    }

    protected Component getComponentAfterImpl(Container focusCycleRoot, Component aComponent) {
        return super.getComponentAfter(focusCycleRoot, aComponent);
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        if (myOverridenDefaultComponent != null) {
            return myOverridenDefaultComponent;
        }
        return this.getComponentBeforeImpl(focusCycleRoot, aComponent);
    }

    @Override
    public Component getInitialComponent(JInternalFrame frame) {
        if (this.isNoDefaultComponent()) {
            return null;
        }
        return super.getInitialComponent(frame);
    }

    @Override
    public Component getInitialComponent(Window window) {
        if (this.isNoDefaultComponent()) {
            return null;
        }
        return super.getInitialComponent(window);
    }

    protected Component getComponentBeforeImpl(Container focusCycleRoot, Component aComponent) {
        return super.getComponentBefore(focusCycleRoot, aComponent);
    }

    public Component queryImpl(Computable<Component> runnable2) {
        try {
            this.myQueryImpl = true;
            Component component = (Component)runnable2.compute();
            return component;
        }
        finally {
            this.myQueryImpl = false;
        }
    }
}

