/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DesktopLayout
implements JDOMExternalizable {
    @NonNls
    static final String TAG = "layout";
    private final Map<String, WindowInfoImpl> myRegisteredId2Info = new HashMap();
    private final Map<String, WindowInfoImpl> myUnregisteredId2Info = new HashMap();
    private static final MyWindowInfoComparator ourWindowInfoComparator = new MyWindowInfoComparator();
    private WindowInfoImpl[] myRegisteredInfos;
    private WindowInfoImpl[] myUnregisteredInfos;
    private WindowInfoImpl[] myAllInfos;
    @NonNls
    public static final String ID_ATTR = "id";

    public final void copyFrom(DesktopLayout layout) {
        WindowInfoImpl[] infos;
        for (WindowInfoImpl info1 : infos = layout.getAllInfos()) {
            WindowInfoImpl info = this.myRegisteredId2Info.get(info1.getId());
            if (info != null) {
                info.copyFrom(info1);
                continue;
            }
            info = this.myUnregisteredId2Info.get(info1.getId());
            if (info != null) {
                info.copyFrom(info1);
                continue;
            }
            this.myUnregisteredId2Info.put(info1.getId(), info1.copy());
        }
        this.myRegisteredInfos = null;
        this.myUnregisteredInfos = null;
        this.myAllInfos = null;
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.TOP));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.LEFT));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.BOTTOM));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.RIGHT));
    }

    final WindowInfoImpl register(@NotNull String id, @NotNull ToolWindowAnchor anchor, boolean splitMode) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ID_ATTR, "com/intellij/openapi/wm/impl/DesktopLayout", "register"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/DesktopLayout", "register"));
        }
        WindowInfoImpl info = this.myUnregisteredId2Info.get(id);
        if (info != null) {
            this.myUnregisteredId2Info.remove(id);
        } else {
            info = new WindowInfoImpl(id);
            info.setAnchor(anchor);
            info.setSplit(splitMode);
        }
        this.myRegisteredId2Info.put(id, info);
        this.myRegisteredInfos = null;
        this.myUnregisteredInfos = null;
        this.myAllInfos = null;
        return info;
    }

    final void unregister(String id) {
        WindowInfoImpl info = this.myRegisteredId2Info.remove(id).copy();
        this.myUnregisteredId2Info.put(id, info);
        this.myRegisteredInfos = null;
        this.myUnregisteredInfos = null;
        this.myAllInfos = null;
    }

    final WindowInfoImpl getInfo(String id, boolean onlyRegistered) {
        WindowInfoImpl info = this.myRegisteredId2Info.get(id);
        if (onlyRegistered || info != null) {
            return info;
        }
        return this.myUnregisteredId2Info.get(id);
    }

    @Nullable
    final String getActiveId() {
        WindowInfoImpl[] infos;
        for (WindowInfoImpl info : infos = this.getInfos()) {
            if (!info.isActive()) continue;
            return info.getId();
        }
        return null;
    }

    final WindowInfoImpl[] getInfos() {
        if (this.myRegisteredInfos == null) {
            this.myRegisteredInfos = this.myRegisteredId2Info.values().toArray(new WindowInfoImpl[this.myRegisteredId2Info.size()]);
        }
        return this.myRegisteredInfos;
    }

    private WindowInfoImpl[] getUnregisteredInfos() {
        if (this.myUnregisteredInfos == null) {
            this.myUnregisteredInfos = this.myUnregisteredId2Info.values().toArray(new WindowInfoImpl[this.myUnregisteredId2Info.size()]);
        }
        return this.myUnregisteredInfos;
    }

    WindowInfoImpl[] getAllInfos() {
        Object[] registeredInfos = this.getInfos();
        Object[] unregisteredInfos = this.getUnregisteredInfos();
        this.myAllInfos = (WindowInfoImpl[])ArrayUtil.mergeArrays((Object[])registeredInfos, (Object[])unregisteredInfos);
        return this.myAllInfos;
    }

    private WindowInfoImpl[] getAllInfos(ToolWindowAnchor anchor) {
        WindowInfoImpl[] infos = this.getAllInfos();
        ArrayList<WindowInfoImpl> list = new ArrayList<WindowInfoImpl>(infos.length);
        for (WindowInfoImpl info : infos) {
            if (anchor != info.getAnchor()) continue;
            list.add(info);
        }
        infos = list.toArray(new WindowInfoImpl[list.size()]);
        Arrays.sort(infos, ourWindowInfoComparator);
        return infos;
    }

    private static void normalizeOrder(WindowInfoImpl[] infos) {
        for (int i = 0; i < infos.length; ++i) {
            infos[i].setOrder(i);
        }
    }

    final boolean isToolWindowRegistered(String id) {
        return this.myRegisteredId2Info.containsKey(id);
    }

    final Comparator<StripeButton> comparator(ToolWindowAnchor anchor) {
        return new MyStripeButtonComparator(anchor);
    }

    private int getMaxOrder(ToolWindowAnchor anchor) {
        WindowInfoImpl[] infos;
        int res = -1;
        for (WindowInfoImpl info : infos = this.getAllInfos()) {
            if (anchor != info.getAnchor() || res >= info.getOrder()) continue;
            res = info.getOrder();
        }
        return res;
    }

    final void setAnchor(String id, ToolWindowAnchor newAnchor, int newOrder) {
        if (newOrder == -1) {
            newOrder = this.getMaxOrder(newAnchor) + 1;
        }
        WindowInfoImpl info = this.getInfo(id, true);
        ToolWindowAnchor oldAnchor = info.getAnchor();
        WindowInfoImpl[] infos = this.getAllInfos(newAnchor);
        for (int i = infos.length - 1; i > -1; --i) {
            WindowInfoImpl info2 = infos[i];
            if (newOrder > info2.getOrder()) continue;
            info2.setOrder(info2.getOrder() + 1);
        }
        info.setAnchor(newAnchor);
        info.setOrder(newOrder);
        DesktopLayout.normalizeOrder(this.getAllInfos(oldAnchor));
        if (oldAnchor != newAnchor) {
            DesktopLayout.normalizeOrder(this.getAllInfos(newAnchor));
        }
    }

    final void setSplitMode(String id, boolean split) {
        WindowInfoImpl info = this.getInfo(id, true);
        info.setSplit(split);
    }

    public final void readExternal(Element layoutElement) {
        this.myUnregisteredInfos = null;
        for (Object o : layoutElement.getChildren()) {
            Element e = (Element)o;
            if (!"window_info".equals(e.getName())) continue;
            String id = e.getAttributeValue(ID_ATTR);
            assert (id != null);
            WindowInfoImpl info = new WindowInfoImpl(id);
            info.readExternal(e);
            if (info.getOrder() == -1) {
                info.setOrder(this.getMaxOrder(info.getAnchor()) + 1);
            }
            this.myUnregisteredId2Info.put(info.getId(), info);
        }
    }

    public final void writeExternal(Element layoutElement) {
        WindowInfoImpl[] infos;
        for (WindowInfoImpl info : infos = this.getAllInfos()) {
            Element element = new Element("window_info");
            info.writeExternal(element);
            layoutElement.addContent(element);
        }
    }

    public List<String> getVisibleIdsOn(ToolWindowAnchor anchor, ToolWindowManagerImpl manager) {
        ArrayList<String> ids = new ArrayList<String>();
        for (WindowInfoImpl each : this.getAllInfos(anchor)) {
            if (manager == null) break;
            ToolWindow window = manager.getToolWindow(each.getId());
            if (window == null || !window.isAvailable() && !UISettings.getInstance().ALWAYS_SHOW_WINDOW_BUTTONS) continue;
            ids.add(each.getId());
        }
        return ids;
    }

    private final class MyStripeButtonComparator
    implements Comparator<StripeButton> {
        private final HashMap<String, WindowInfoImpl> myId2Info = new HashMap();

        public MyStripeButtonComparator(ToolWindowAnchor anchor) {
            WindowInfoImpl[] infos;
            for (WindowInfoImpl info : infos = DesktopLayout.this.getInfos()) {
                if (anchor != info.getAnchor()) continue;
                this.myId2Info.put((Object)info.getId(), (Object)info.copy());
            }
        }

        @Override
        public final int compare(StripeButton obj1, StripeButton obj2) {
            WindowInfoImpl info1 = (WindowInfoImpl)this.myId2Info.get((Object)obj1.getWindowInfo().getId());
            int order1 = info1 != null ? info1.getOrder() : 0;
            WindowInfoImpl info2 = (WindowInfoImpl)this.myId2Info.get((Object)obj2.getWindowInfo().getId());
            int order2 = info2 != null ? info2.getOrder() : 0;
            return order1 - order2;
        }
    }

    private static final class MyWindowInfoComparator
    implements Comparator<WindowInfoImpl> {
        private MyWindowInfoComparator() {
        }

        @Override
        public int compare(WindowInfoImpl info1, WindowInfoImpl info2) {
            return info1.getOrder() - info2.getOrder();
        }
    }
}

