/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.HideableProjectGenerator;
import com.intellij.platform.LocationNameFieldsBinding;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewDirectoryProjectDialog
extends DialogWrapper {
    private static final Object EMPTY_PROJECT_GENERATOR = new Object();
    private JPanel myRootPane;
    private JTextField myProjectNameTextField;
    private JLabel myLocationLabel;
    private TextFieldWithBrowseButton myLocationField;
    private JComboBox myProjectTypeComboBox;

    protected NewDirectoryProjectDialog(@Nullable Project project) {
        super(project, true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(IdeBundle.message((String)"new.dir.project.title", (Object[])objectArray));
        this.init();
        this.myLocationLabel.setLabelFor(this.myLocationField.getChildComponent());
        String title = IdeBundle.message((String)"new.dir.project.chooser.title", (Object[])new Object[0]);
        new LocationNameFieldsBinding(project, this.myLocationField, this.myProjectNameTextField, ProjectUtil.getBaseDir(), title);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        model.addElement(EMPTY_PROJECT_GENERATOR);
        DirectoryProjectGenerator[] generators = (DirectoryProjectGenerator[])Extensions.getExtensions(DirectoryProjectGenerator.EP_NAME);
        if (generators.length > 0) {
            ArrayList primaryGenerators = ContainerUtil.newArrayList();
            ArrayList otherGenerators = ContainerUtil.newArrayList();
            for (DirectoryProjectGenerator generator : generators) {
                if (generator instanceof HideableProjectGenerator && ((HideableProjectGenerator)((Object)generator)).isHidden()) continue;
                if (generator instanceof WebProjectGenerator && ((WebProjectGenerator)generator).isPrimaryGenerator()) {
                    primaryGenerators.add(generator);
                    continue;
                }
                otherGenerators.add(generator);
            }
            for (DirectoryProjectGenerator generator : primaryGenerators) {
                model.addElement(generator);
            }
            for (DirectoryProjectGenerator generator : otherGenerators) {
                model.addElement(generator);
            }
        }
        this.myProjectTypeComboBox.setModel(model);
        this.myProjectTypeComboBox.setRenderer(NewDirectoryProjectDialog.createProjectTypeListCellRenderer());
        this.myLocationField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                NewDirectoryProjectDialog.this.checkValid();
            }
        });
        this.myProjectTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/platform/NewDirectoryProjectDialog$2", "actionPerformed"));
                }
                NewDirectoryProjectDialog.this.checkValid();
            }
        });
    }

    @NotNull
    private static ListCellRendererWrapper<Object> createProjectTypeListCellRenderer() {
        ListCellRendererWrapper<Object> listCellRendererWrapper = new ListCellRendererWrapper<Object>(){

            public void customize(JList list, Object value, int index, boolean selected, boolean cellHasFocus) {
                if (value == EMPTY_PROJECT_GENERATOR) {
                    this.setText(IdeBundle.message((String)"new.dir.project.default.generator", (Object[])new Object[0]));
                } else if (value != null) {
                    this.setText(((DirectoryProjectGenerator)value).getName());
                }
            }
        };
        if (listCellRendererWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/NewDirectoryProjectDialog", "createProjectTypeListCellRenderer"));
        }
        return listCellRendererWrapper;
    }

    private void checkValid() {
        String baseDirPath;
        ValidationResult validationResult;
        String projectName = this.myProjectNameTextField.getText();
        if (projectName.trim().isEmpty()) {
            this.setOKActionEnabled(false);
            this.setErrorText(IdeBundle.message((String)"new.dir.project.error.empty", (Object[])new Object[0]));
            return;
        }
        if (this.myLocationField.getText().indexOf(36) >= 0) {
            this.setOKActionEnabled(false);
            this.setErrorText(IdeBundle.message((String)"new.dir.project.error.buck", (Object[])new Object[0]));
            return;
        }
        DirectoryProjectGenerator generator = this.getProjectGenerator();
        if (generator != null && !(validationResult = generator.validate(baseDirPath = this.myLocationField.getTextField().getText())).isOk()) {
            this.setOKActionEnabled(false);
            this.setErrorText(validationResult.getErrorMessage());
            return;
        }
        this.setOKActionEnabled(true);
        this.setErrorText(null);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myProjectNameTextField;
    }

    protected JComponent createCenterPanel() {
        return this.myRootPane;
    }

    protected String getHelpId() {
        return "create_new_project_dialog";
    }

    public String getNewProjectLocation() {
        return this.myLocationField.getText();
    }

    @Nullable
    public DirectoryProjectGenerator getProjectGenerator() {
        Object item = this.myProjectTypeComboBox.getSelectedItem();
        return item == EMPTY_PROJECT_GENERATOR ? null : (DirectoryProjectGenerator)item;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JTextField jTextField;
        JPanel jPanel;
        this.myRootPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Project name:");
        jLabel2.setDisplayedMnemonic('N');
        jLabel2.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectNameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(450, -1), null));
        this.myLocationLabel = jLabel = new JLabel();
        jLabel.setText("Location:");
        jLabel.setDisplayedMnemonic('L');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocationField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 3, 6, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Project type:");
        jLabel3.setDisplayedMnemonic('T');
        jLabel3.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectTypeComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel2.setLabelFor(jTextField);
        jLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPane;
    }
}

