/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

abstract class ClsPrefixExpressionImpl
extends ClsElementImpl
implements PsiPrefixExpression {
    private final ClsElementImpl myParent;
    private final PsiJavaToken myOperation;
    private final PsiExpression myOperand;

    ClsPrefixExpressionImpl(ClsElementImpl parent) {
        this.myParent = parent;
        this.myOperation = this.createOperation();
        this.myOperand = this.createOperand();
    }

    @NotNull
    protected abstract PsiExpression createOperand();

    @NotNull
    protected abstract PsiJavaToken createOperation();

    @NotNull
    public PsiExpression getOperand() {
        PsiExpression psiExpression = this.myOperand;
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl", "getOperand"));
        }
        return psiExpression;
    }

    @NotNull
    public PsiJavaToken getOperationSign() {
        PsiJavaToken psiJavaToken = this.myOperation;
        if (psiJavaToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl", "getOperationSign"));
        }
        return psiJavaToken;
    }

    @NotNull
    public IElementType getOperationTokenType() {
        IElementType iElementType = this.myOperation.getTokenType();
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl", "getOperationTokenType"));
        }
        return iElementType;
    }

    public PsiType getType() {
        return this.myOperand.getType();
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myOperation, this.myOperand};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public String getText() {
        return StringUtil.join((String[])new String[]{this.myOperation.getText(), this.myOperand.getText()});
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl", "appendMirrorText"));
        }
        buffer.append(this.getText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaElementType.PREFIX_EXPRESSION);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPrefixExpression((PsiPrefixExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiPrefixExpression:" + this.getText();
    }
}

