/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationWithSeparator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.injected.XmlAttributeLiteralEscaper;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeValueImpl
extends XmlElementImpl
implements XmlAttributeValue,
PsiLanguageInjectionHost,
PsiMetaOwner,
PsiMetaData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlAttributeValueImpl");
    private volatile PsiReference[] myCachedReferences;
    private volatile long myModCount;

    public XmlAttributeValueImpl() {
        super(XmlElementType.XML_ATTRIBUTE_VALUE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/xml/XmlAttributeValueImpl", "accept"));
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttributeValue((XmlAttributeValue)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getValue() {
        ASTNode endQuote;
        String text = this.getText();
        ASTNode startQuote = this.findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER);
        if (startQuote != null) {
            text = StringUtil.trimStart((String)text, (String)startQuote.getText());
        }
        if ((endQuote = this.findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER)) != null) {
            text = StringUtil.trimEnd((String)text, (String)endQuote.getText());
        }
        return text;
    }

    public TextRange getValueTextRange() {
        TextRange range = this.getTextRange();
        String value = this.getValue();
        if (value.isEmpty()) {
            return range;
        }
        int start = range.getStartOffset() + this.getText().indexOf(value);
        int end = start + value.length();
        return new TextRange(start, end);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedReferences = null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] cachedReferences = this.myCachedReferences;
        long curModCount = this.getManager().getModificationTracker().getModificationCount();
        if (cachedReferences != null && this.myModCount == curModCount) {
            if (cachedReferences == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeValueImpl", "getReferences"));
            }
            return cachedReferences;
        }
        this.myCachedReferences = cachedReferences = ReferenceProvidersRegistry.getReferencesFromProviders(this);
        this.myModCount = curModCount;
        if (cachedReferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeValueImpl", "getReferences"));
        }
        return cachedReferences;
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] refs = this.getReferences();
        if (refs.length > 0) {
            return refs[0];
        }
        return null;
    }

    @Override
    public int getTextOffset() {
        return this.getTextRange().getStartOffset() + 1;
    }

    public boolean isValidHost() {
        return this.getParent() instanceof XmlAttributeImpl;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/xml/XmlAttributeValueImpl", "updateText"));
        }
        try {
            String quoteChar = this.getTextLength() > 0 ? this.getText().substring(0, 1) : "";
            String contents = StringUtil.containsAnyChar((String)quoteChar, (String)"'\"") ? StringUtil.trimEnd((String)StringUtil.trimStart((String)text, (String)quoteChar), (String)quoteChar) : text;
            XmlAttribute newAttribute = XmlElementFactory.getInstance((Project)this.getProject()).createXmlAttribute("q", contents);
            XmlAttributeValue newValue = newAttribute.getValueElement();
            CheckUtil.checkWritable(this);
            this.replaceAllChildrenToChildrenOf(newValue.getNode());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    @NotNull
    public LiteralTextEscaper<XmlAttributeValueImpl> createLiteralTextEscaper() {
        XmlAttributeLiteralEscaper xmlAttributeLiteralEscaper = new XmlAttributeLiteralEscaper(this);
        if (xmlAttributeLiteralEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeValueImpl", "createLiteralTextEscaper"));
        }
        return xmlAttributeLiteralEscaper;
    }

    public PsiMetaData getMetaData() {
        return this;
    }

    public PsiElement getDeclaration() {
        return this;
    }

    public String getName(PsiElement context) {
        return this.getValue();
    }

    @Override
    public String getName() {
        return this.getValue();
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentationWithSeparator(){

            public String getPresentableText() {
                return XmlAttributeValueImpl.this.getText();
            }

            public String getLocationString() {
                return SymbolPresentationUtil.getFilePathPresentation(XmlAttributeValueImpl.this.getContainingFile());
            }

            public Icon getIcon(boolean open2) {
                return null;
            }
        };
    }
}

