/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiMatcher;
import com.intellij.psi.util.PsiMatcherExpression;

public class PsiMatcherImpl
implements PsiMatcher {
    private PsiElement myElement;

    public PsiMatcherImpl(PsiElement element) {
        this.myElement = element;
    }

    @Override
    public PsiMatcher parent(PsiMatcherExpression e) {
        this.myElement = this.myElement.getParent();
        if (this.myElement == null || e != null && e.match(this.myElement) != Boolean.TRUE) {
            return NullPsiMatcherImpl.INSTANCE;
        }
        return this;
    }

    @Override
    public PsiMatcher firstChild(PsiMatcherExpression e) {
        PsiElement[] children2;
        PsiElement[] psiElementArray = children2 = this.myElement.getChildren();
        int n = psiElementArray.length;
        for (int i = 0; i < n; ++i) {
            PsiElement child;
            this.myElement = child = psiElementArray[i];
            if (e != null && e.match(this.myElement) != Boolean.TRUE) continue;
            return this;
        }
        return NullPsiMatcherImpl.INSTANCE;
    }

    @Override
    public PsiMatcher ancestor(PsiMatcherExpression e) {
        while (this.myElement != null) {
            Boolean res;
            Boolean bl = res = e == null ? Boolean.TRUE : e.match(this.myElement);
            if (res == Boolean.TRUE) break;
            if (res == null) {
                return NullPsiMatcherImpl.INSTANCE;
            }
            this.myElement = this.myElement.getParent();
        }
        if (this.myElement == null) {
            return NullPsiMatcherImpl.INSTANCE;
        }
        return this;
    }

    @Override
    public PsiMatcher descendant(PsiMatcherExpression e) {
        PsiElement[] children2;
        PsiElement[] psiElementArray = children2 = this.myElement.getChildren();
        int n = psiElementArray.length;
        for (int i = 0; i < n; ++i) {
            PsiMatcher grandChild;
            Boolean res;
            PsiElement child;
            this.myElement = child = psiElementArray[i];
            Boolean bl = res = e == null ? Boolean.TRUE : e.match(this.myElement);
            if (res == Boolean.TRUE) {
                return this;
            }
            if (res != Boolean.FALSE || (grandChild = this.descendant(e)) == NullPsiMatcherImpl.INSTANCE) continue;
            return grandChild;
        }
        return NullPsiMatcherImpl.INSTANCE;
    }

    @Override
    public PsiMatcher dot(PsiMatcherExpression e) {
        return e == null || e.match(this.myElement) == Boolean.TRUE ? this : NullPsiMatcherImpl.INSTANCE;
    }

    @Override
    public PsiElement getElement() {
        return this.myElement;
    }

    private static class NullPsiMatcherImpl
    implements PsiMatcher {
        private static final NullPsiMatcherImpl INSTANCE = new NullPsiMatcherImpl();

        private NullPsiMatcherImpl() {
        }

        @Override
        public PsiMatcher parent(PsiMatcherExpression e) {
            return this;
        }

        @Override
        public PsiMatcher firstChild(PsiMatcherExpression e) {
            return this;
        }

        @Override
        public PsiMatcher ancestor(PsiMatcherExpression e) {
            return this;
        }

        @Override
        public PsiMatcher descendant(PsiMatcherExpression e) {
            return this;
        }

        @Override
        public PsiMatcher dot(PsiMatcherExpression e) {
            return this;
        }

        @Override
        public PsiElement getElement() {
            return null;
        }
    }
}

