/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExplicitlyImportedWeigher
extends ProximityWeigher {
    private static final NullableLazyKey<PsiPackage, ProximityLocation> PLACE_PACKAGE = NullableLazyKey.create((String)"placePackage", (NullableFunction)new NullableFunction<ProximityLocation, PsiPackage>(){

        public PsiPackage fun(ProximityLocation location) {
            PsiElement position = location.getPosition();
            if (position == null) {
                return null;
            }
            return ExplicitlyImportedWeigher.getContextPackage(position);
        }
    });
    private static final NotNullLazyKey<List<String>, ProximityLocation> PLACE_IMPORTED_NAMES = NotNullLazyKey.create((String)"importedNames", (NotNullFunction)new NotNullFunction<ProximityLocation, List<String>>(){

        @NotNull
        public List<String> fun(ProximityLocation location) {
            PsiImportList importList;
            PsiJavaFile psiJavaFile = (PsiJavaFile)PsiTreeUtil.getContextOfType((PsiElement)location.getPosition(), PsiJavaFile.class, (boolean)false);
            PsiImportList psiImportList = importList = psiJavaFile == null ? null : psiJavaFile.getImportList();
            if (importList == null) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/proximity/ExplicitlyImportedWeigher$2", "fun"));
                }
                return list;
            }
            ArrayList importedNames = ContainerUtil.newArrayList();
            for (PsiImportStatement importStatement : importList.getImportStatements()) {
                ContainerUtil.addIfNotNull((Collection)importedNames, (Object)importStatement.getQualifiedName());
            }
            ArrayList arrayList = importedNames;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/proximity/ExplicitlyImportedWeigher$2", "fun"));
            }
            return arrayList;
        }
    });

    @Nullable
    private static PsiPackage getContextPackage(PsiElement position) {
        PsiFile file2 = position.getContainingFile();
        if (file2 == null) {
            return null;
        }
        PsiFile originalFile = file2.getOriginalFile();
        while (true) {
            PsiElement context;
            if ((context = originalFile.getContext()) == null) {
                PsiDirectory parent = originalFile.getParent();
                if (parent != null) {
                    return JavaDirectoryService.getInstance().getPackage(parent);
                }
                return null;
            }
            PsiFile containingFile = context.getContainingFile();
            if (containingFile == null) {
                return null;
            }
            originalFile = containingFile.getOriginalFile();
        }
    }

    @Override
    public Integer weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        PsiPackage placePackage;
        String qname;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/proximity/ExplicitlyImportedWeigher", "weigh"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/psi/util/proximity/ExplicitlyImportedWeigher", "weigh"));
        }
        PsiElement position = location.getPosition();
        if (position == null) {
            return 0;
        }
        PsiUtilCore.ensureValid((PsiElement)position);
        PsiFile elementFile = element.getContainingFile();
        PsiFile positionFile = position.getContainingFile();
        if (positionFile != null && elementFile != null && positionFile.getOriginalFile().equals(elementFile.getOriginalFile())) {
            return 300;
        }
        if (element instanceof PsiClass && (qname = ((PsiClass)element).getQualifiedName()) != null) {
            List importedNames = (List)PLACE_IMPORTED_NAMES.getValue((UserDataHolder)location);
            if (importedNames.contains(qname)) {
                return 100;
            }
            String pkg = StringUtil.getPackageName((String)qname);
            while (!pkg.isEmpty()) {
                if (ExplicitlyImportedWeigher.containsImport(importedNames, pkg)) {
                    return StringUtil.countChars((CharSequence)pkg, (char)'.') + 1;
                }
                pkg = StringUtil.getPackageName((String)pkg);
            }
        }
        if (element instanceof PsiMember && (placePackage = (PsiPackage)PLACE_PACKAGE.getValue((UserDataHolder)location)) != null) {
            Module elementModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (location.getPositionModule() == elementModule && placePackage.equals(ExplicitlyImportedWeigher.getContextPackage(element))) {
                return 200;
            }
        }
        return 0;
    }

    private static boolean containsImport(List<String> importedNames, final String pkg) {
        return ContainerUtil.or(importedNames, (Condition)new Condition<String>(){

            public boolean value(String s) {
                return s.startsWith(pkg + '.') || s.equals(pkg);
            }
        });
    }
}

