/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeClassSignature;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureProcessor;
import com.intellij.refactoring.changeClassSignature.TypeParameterInfo;
import com.intellij.refactoring.ui.CodeFragmentTableCellRenderer;
import com.intellij.refactoring.ui.JavaCodeFragmentTableCellEditor;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TableColumnAnimator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeClassSignatureDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance(ChangeClassSignatureDialog.class);
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private final List<TypeParameterInfo> myTypeParameterInfos;
    private final List<PsiTypeCodeFragment> myTypeCodeFragments;
    private final PsiClass myClass;
    private final PsiTypeParameter[] myOriginalParameters;
    private final Project myProject;
    private final MyTableModel myTableModel;
    private JBTable myTable;
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"changeClassSignature.refactoring.name");
    private final boolean myHideDefaultValueColumn;

    public ChangeClassSignatureDialog(@NotNull PsiClass aClass, boolean hideDefaultValueColumn) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureDialog", "<init>"));
        }
        this(aClass, ChangeClassSignatureDialog.initTypeParameterInfos(aClass.getTypeParameters().length), ChangeClassSignatureDialog.initTypeCodeFragment(aClass.getTypeParameters().length), hideDefaultValueColumn);
    }

    @NotNull
    private static List<TypeParameterInfo> initTypeParameterInfos(int length) {
        ArrayList<TypeParameterInfo> result2 = new ArrayList<TypeParameterInfo>();
        for (int i = 0; i < length; ++i) {
            result2.add(new TypeParameterInfo(i));
        }
        ArrayList<TypeParameterInfo> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureDialog", "initTypeParameterInfos"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiTypeCodeFragment> initTypeCodeFragment(int length) {
        ArrayList<PsiTypeCodeFragment> result2 = new ArrayList<PsiTypeCodeFragment>();
        for (int i = 0; i < length; ++i) {
            result2.add(null);
        }
        ArrayList<PsiTypeCodeFragment> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureDialog", "initTypeCodeFragment"));
        }
        return arrayList;
    }

    public ChangeClassSignatureDialog(@NotNull PsiClass aClass, @NotNull Map<TypeParameterInfo, PsiTypeCodeFragment> parameters, boolean hideDefaultValueColumn) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureDialog", "<init>"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureDialog", "<init>"));
        }
        this(aClass, parameters.keySet(), parameters.values(), hideDefaultValueColumn);
    }

    public ChangeClassSignatureDialog(@NotNull PsiClass aClass, @NotNull Collection<TypeParameterInfo> typeParameterInfos, @NotNull Collection<PsiTypeCodeFragment> typeCodeFragments, boolean hideDefaultValueColumn) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureDialog", "<init>"));
        }
        if (typeParameterInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterInfos", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureDialog", "<init>"));
        }
        if (typeCodeFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCodeFragments", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureDialog", "<init>"));
        }
        super(aClass.getProject(), true);
        this.myHideDefaultValueColumn = hideDefaultValueColumn;
        this.setTitle(REFACTORING_NAME);
        this.myClass = aClass;
        this.myProject = this.myClass.getProject();
        this.myOriginalParameters = this.myClass.getTypeParameters();
        this.myTypeParameterInfos = new ArrayList<TypeParameterInfo>(typeParameterInfos);
        this.myTypeCodeFragments = new ArrayList<PsiTypeCodeFragment>(typeCodeFragments);
        this.myTableModel = new MyTableModel();
        this.init();
    }

    private PsiTypeCodeFragment createValueCodeFragment() {
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)this.myProject);
        return factory.createTypeCodeFragment("", this.myClass.getLBrace(), true);
    }

    protected JComponent createNorthPanel() {
        return new JLabel(RefactoringBundle.message((String)"changeClassSignature.class.label.text", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myClass)}));
    }

    protected String getHelpId() {
        return "change.class.signature.dialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected JComponent createCenterPanel() {
        this.myTable = new JBTable((TableModel)this.myTableModel);
        this.myTable.setStriped(true);
        TableColumn nameColumn = this.myTable.getColumnModel().getColumn(0);
        TableColumn valueColumn = this.myTable.getColumnModel().getColumn(1);
        Project project = this.myClass.getProject();
        nameColumn.setCellRenderer((TableCellRenderer)((Object)new MyCellRenderer()));
        nameColumn.setCellEditor(new StringTableCellEditor(project));
        valueColumn.setCellRenderer(new MyCodeFragmentTableCellRenderer());
        valueColumn.setCellEditor(new JavaCodeFragmentTableCellEditor(project));
        this.myTable.setPreferredScrollableViewportSize(new Dimension(210, this.myTable.getRowHeight() * 4));
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        this.myTable.setSurrendersFocusOnKeystroke(true);
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.setFocusCycleRoot(true);
        if (this.myHideDefaultValueColumn) {
            final TableColumn defaultValue = this.myTable.getColumnModel().getColumn(1);
            this.myTable.removeColumn(defaultValue);
            this.myTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getType() == 1) {
                        ChangeClassSignatureDialog.this.myTable.getModel().removeTableModelListener(this);
                        TableColumnAnimator animator = new TableColumnAnimator((JTable)ChangeClassSignatureDialog.this.myTable);
                        animator.setStep(20);
                        animator.addColumn(defaultValue, ChangeClassSignatureDialog.this.myTable.getWidth() / 2);
                        animator.startAndDoWhenDone(new Runnable(){

                            @Override
                            public void run() {
                                ChangeClassSignatureDialog.this.myTable.editCellAt(ChangeClassSignatureDialog.this.myTable.getRowCount() - 1, 0);
                            }
                        });
                        animator.start();
                    }
                }
            });
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)SeparatorFactory.createSeparator((String)RefactoringBundle.message((String)"changeClassSignature.parameters.panel.border.title"), (JComponent)this.myTable), "North");
        panel.add((Component)ToolbarDecorator.createDecorator((JTable)this.myTable).createPanel(), "Center");
        return panel;
    }

    @Override
    protected void doAction() {
        TableUtil.stopEditing((JTable)this.myTable);
        String message = this.validateAndCommitData();
        if (message != null) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.incorrect.data"), (String)message, (String)"refactoring.changeSignature", (Project)this.myClass.getProject());
            return;
        }
        ChangeClassSignatureProcessor processor2 = new ChangeClassSignatureProcessor(this.myClass.getProject(), this.myClass, this.myTypeParameterInfos.toArray(new TypeParameterInfo[this.myTypeParameterInfos.size()]));
        this.invokeRefactoring(processor2);
    }

    private String validateAndCommitData() {
        PsiTypeParameter[] parameters = this.myClass.getTypeParameters();
        HashMap<String, TypeParameterInfo> infos = new HashMap<String, TypeParameterInfo>();
        for (TypeParameterInfo info : this.myTypeParameterInfos) {
            if (!info.isForExistingParameter() && !PsiNameHelper.getInstance((Project)this.myClass.getProject()).isIdentifier(info.getNewName())) {
                return RefactoringBundle.message((String)"error.wrong.name.input", (Object[])new Object[]{info.getNewName()});
            }
            String newName = info.isForExistingParameter() ? parameters[info.getOldParameterIndex()].getName() : info.getNewName();
            TypeParameterInfo existing = (TypeParameterInfo)infos.get(newName);
            if (existing != null) {
                return this.myClass.getName() + " already contains type parameter " + newName;
            }
            infos.put(newName, info);
        }
        LOG.assertTrue(this.myTypeCodeFragments.size() == this.myTypeParameterInfos.size());
        for (int i = 0; i < this.myTypeCodeFragments.size(); ++i) {
            PsiType type;
            PsiTypeCodeFragment codeFragment = this.myTypeCodeFragments.get(i);
            TypeParameterInfo info = this.myTypeParameterInfos.get(i);
            if (info.getOldParameterIndex() >= 0) continue;
            try {
                type = codeFragment.getType();
                if (type instanceof PsiPrimitiveType) {
                    return "Type parameter can't be primitive";
                }
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                return RefactoringBundle.message((String)"changeClassSignature.bad.default.value", (Object[])new Object[]{codeFragment.getText(), info.getNewName()});
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                return RefactoringBundle.message((String)"changeSignature.no.type.for.parameter", (Object[])new Object[]{info.getNewName()});
            }
            info.setDefaultValue(type);
        }
        return null;
    }

    private class MyCodeFragmentTableCellRenderer
    extends CodeFragmentTableCellRenderer {
        public MyCodeFragmentTableCellRenderer() {
            super(ChangeClassSignatureDialog.this.getProject());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return component;
        }
    }

    private class MyCellRenderer
    extends ColoredTableCellRenderer {
        private MyCellRenderer() {
        }

        public void customizeCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value == null) {
                return;
            }
            this.setPaintFocusBorder(false);
            this.acquireState(table, isSelected, false, row, col);
            this.getCellState().updateRenderer((JComponent)((Object)this));
            this.append((String)value);
        }
    }

    private class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ChangeClassSignatureDialog.this.myTypeParameterInfos.size();
        }

        @Nullable
        public Class getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    TypeParameterInfo info = (TypeParameterInfo)ChangeClassSignatureDialog.this.myTypeParameterInfos.get(rowIndex);
                    if (info.isForExistingParameter()) {
                        return ChangeClassSignatureDialog.this.myOriginalParameters[info.getOldParameterIndex()].getName();
                    }
                    return info.getNewName();
                }
                case 1: {
                    return ChangeClassSignatureDialog.this.myTypeCodeFragments.get(rowIndex);
                }
            }
            LOG.assertTrue(false);
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return !((TypeParameterInfo)ChangeClassSignatureDialog.this.myTypeParameterInfos.get(rowIndex)).isForExistingParameter();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return RefactoringBundle.message((String)"column.name.name");
                }
                case 1: {
                    return RefactoringBundle.message((String)"changeSignature.default.value.column");
                }
            }
            LOG.assertTrue(false);
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ((TypeParameterInfo)ChangeClassSignatureDialog.this.myTypeParameterInfos.get(rowIndex)).setNewName((String)aValue);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    LOG.assertTrue(false);
                }
            }
        }

        public void addRow() {
            TableUtil.stopEditing((JTable)ChangeClassSignatureDialog.this.myTable);
            ChangeClassSignatureDialog.this.myTypeParameterInfos.add(new TypeParameterInfo("", null));
            ChangeClassSignatureDialog.this.myTypeCodeFragments.add(ChangeClassSignatureDialog.this.createValueCodeFragment());
            int row = ChangeClassSignatureDialog.this.myTypeCodeFragments.size() - 1;
            this.fireTableRowsInserted(row, row);
        }

        public void removeRow(int index) {
            ChangeClassSignatureDialog.this.myTypeParameterInfos.remove(index);
            ChangeClassSignatureDialog.this.myTypeCodeFragments.remove(index);
            this.fireTableDataChanged();
        }

        public void exchangeRows(int index1, int index2) {
            ContainerUtil.swapElements((List)ChangeClassSignatureDialog.this.myTypeParameterInfos, (int)index1, (int)index2);
            ContainerUtil.swapElements((List)ChangeClassSignatureDialog.this.myTypeCodeFragments, (int)index1, (int)index2);
            this.fireTableDataChanged();
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }
    }
}

