/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.extractclass.ExtractClassDialog;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class ExtractClassHandler
implements ElementsHandler {
    protected static String getHelpID() {
        return "refactorj.extractClass";
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && PsiTreeUtil.getParentOfType((PsiElement)elements[0], PsiClass.class, (boolean)false) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        String cannotRefactorMessage;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractclass/ExtractClassHandler", "invoke"));
        }
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        PsiElement element = file2.findElementAt(position);
        PsiMember selectedMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class, (boolean)true);
        if (selectedMember == null) {
            return;
        }
        PsiClass containingClass = selectedMember.getContainingClass();
        if (containingClass == null && selectedMember instanceof PsiClass) {
            containingClass = (PsiClass)selectedMember;
        }
        if ((cannotRefactorMessage = ExtractClassHandler.getCannotRefactorMessage(containingClass)) != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)(RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + cannotRefactorMessage), null, (String)ExtractClassHandler.getHelpID());
            return;
        }
        new ExtractClassDialog(containingClass, selectedMember).show();
    }

    private static String getCannotRefactorMessage(PsiClass containingClass) {
        if (containingClass == null) {
            return RefactorJBundle.message("the.caret.should.be.positioned.within.a.class.to.be.refactored", new Object[0]);
        }
        if (containingClass.isInterface()) {
            return RefactorJBundle.message("the.selected.class.is.an.interface", new Object[0]);
        }
        if (containingClass.isEnum()) {
            return RefactorJBundle.message("the.selected.class.is.an.enumeration", new Object[0]);
        }
        if (containingClass.isAnnotationType()) {
            return RefactorJBundle.message("the.selected.class.is.an.annotation.type", new Object[0]);
        }
        if (ExtractClassHandler.classIsInner(containingClass) && !containingClass.hasModifierProperty("static")) {
            return RefactorJBundle.message("the.refactoring.is.not.supported.on.non.static.inner.classes", new Object[0]);
        }
        if (ExtractClassHandler.classIsTrivial(containingClass)) {
            return RefactorJBundle.message("the.selected.class.has.no.members.to.extract", new Object[0]);
        }
        return null;
    }

    private static boolean classIsInner(PsiClass aClass) {
        return PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true) != null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractclass/ExtractClassHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/extractclass/ExtractClassHandler", "invoke"));
        }
        if (elements.length != 1) {
            return;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)elements[0], PsiClass.class, (boolean)false);
        PsiMember selectedMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)elements[0], PsiMember.class, (boolean)false);
        if (containingClass == null) {
            return;
        }
        if (ExtractClassHandler.classIsTrivial(containingClass)) {
            return;
        }
        new ExtractClassDialog(containingClass, selectedMember).show();
    }

    private static boolean classIsTrivial(PsiClass containingClass) {
        if (containingClass.getFields().length == 0) {
            PsiMethod[] methods = containingClass.getMethods();
            if (methods.length == 0) {
                return true;
            }
            for (PsiMethod method : methods) {
                if (method.getBody() == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

