/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CodeFragmentTableCellRenderer
implements TableCellRenderer {
    private final Project myProject;
    private final FileType myFileType;

    public CodeFragmentTableCellRenderer(Project project) {
        this(project, (FileType)StdFileTypes.JAVA);
    }

    public CodeFragmentTableCellRenderer(Project project, FileType fileType) {
        this.myProject = project;
        this.myFileType = fileType;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        EditorTextField editorTextField;
        PsiCodeFragment codeFragment = (PsiCodeFragment)value;
        Document document = null;
        if (codeFragment != null) {
            document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)codeFragment);
            editorTextField = new EditorTextField(document, this.myProject, this.myFileType){

                @Override
                protected boolean shouldHaveBorder() {
                    return false;
                }
            };
        } else {
            editorTextField = new EditorTextField("", this.myProject, this.myFileType){

                @Override
                protected boolean shouldHaveBorder() {
                    return false;
                }
            };
        }
        if (!table.isShowing()) {
            editorTextField.ensureWillComputePreferredSize();
        }
        editorTextField.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        editorTextField.setBorder(hasFocus || isSelected ? BorderFactory.createLineBorder(table.getSelectionBackground()) : IdeBorderFactory.createEmptyBorder((int)1));
        if (isSelected && document != null) {
            Color bg = table.getSelectionBackground();
            Color fg = table.getSelectionForeground();
            editorTextField.setBackground(bg);
            editorTextField.setForeground(fg);
            editorTextField.setAsRendererWithSelection(bg, fg);
        }
        return editorTextField;
    }
}

