/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;

public final class SearchContext {
    private final PsiFile file;
    private final Project project;

    private SearchContext(Project project, PsiFile file2) {
        this.project = project;
        this.file = file2;
    }

    public PsiFile getFile() {
        return this.file;
    }

    public Project getProject() {
        return this.project;
    }

    public static SearchContext buildFromDataContext(DataContext context) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        VirtualFile vFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (!(vFile == null || file2 != null && vFile.equals(file2.getContainingFile().getVirtualFile()))) {
            file2 = PsiManager.getInstance((Project)project).findFile(vFile);
        }
        return new SearchContext(project, file2);
    }

    public Editor getEditor() {
        return FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor();
    }
}

