/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LoggedErrorProcessor {
    private static final LoggedErrorProcessor DEFAULT;
    private static LoggedErrorProcessor ourInstance;

    @NotNull
    public static LoggedErrorProcessor getInstance() {
        LoggedErrorProcessor loggedErrorProcessor = ourInstance;
        if (loggedErrorProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LoggedErrorProcessor", "getInstance"));
        }
        return loggedErrorProcessor;
    }

    public static void setNewInstance(@NotNull LoggedErrorProcessor newInstance) {
        if (newInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newInstance", "com/intellij/testFramework/LoggedErrorProcessor", "setNewInstance"));
        }
        ourInstance = newInstance;
    }

    public static void restoreDefaultProcessor() {
        ourInstance = DEFAULT;
    }

    public void processWarn(String message, Throwable t, @NotNull Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/testFramework/LoggedErrorProcessor", "processWarn"));
        }
        logger.warn((Object)message, t);
    }

    public void processError(String message, Throwable t, String[] details, @NotNull Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/testFramework/LoggedErrorProcessor", "processError"));
        }
        logger.info((Object)message, t);
        System.err.println("ERROR: " + message);
        if (t != null) {
            t.printStackTrace(System.err);
        }
        if (details != null && details.length > 0) {
            System.out.println("details: ");
            for (String detail : details) {
                System.out.println(detail);
            }
        }
        throw new AssertionError((Object)message);
    }

    static {
        ourInstance = DEFAULT = new LoggedErrorProcessor();
    }
}

