/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.intellij.lang.annotations.JdkConstants;

abstract class WindowMouseListener
extends MouseAdapter {
    private final Component myContent;
    @JdkConstants.CursorType
    int myType;
    private Point myLocation;
    private Rectangle myViewBounds;

    WindowMouseListener(Component content) {
        this.myContent = content;
    }

    @JdkConstants.CursorType
    abstract int getCursorType(Component var1, Point var2);

    abstract void updateBounds(Rectangle var1, Component var2, int var3, int var4);

    @Override
    public void mouseMoved(MouseEvent event) {
        this.update(event, false);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.update(event, true);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.process(event, false);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.process(event, true);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.process(event, true);
    }

    private void update(MouseEvent event, boolean start) {
        Component content;
        Component view;
        if (event.isConsumed()) {
            return;
        }
        if (this.myLocation == null && (view = this.getView(content = this.getContent(event))) != null) {
            this.myType = this.getCursorType(view, event.getLocationOnScreen());
            this.setCursor(content, Cursor.getPredefinedCursor(this.myType == -1 ? 0 : this.myType));
            if (start && this.myType != -1) {
                this.myLocation = event.getLocationOnScreen();
                this.myViewBounds = view.getBounds();
                event.consume();
            }
        }
    }

    private void process(MouseEvent event, boolean stop2) {
        if (event.isConsumed()) {
            return;
        }
        if (this.myLocation != null && this.myViewBounds != null) {
            Component content = this.getContent(event);
            Component view = this.getView(content);
            if (view != null) {
                Rectangle bounds = new Rectangle(this.myViewBounds);
                this.updateBounds(bounds, view, event.getXOnScreen() - this.myLocation.x, event.getYOnScreen() - this.myLocation.y);
                if (!bounds.equals(view.getBounds())) {
                    view.setBounds(bounds);
                    view.invalidate();
                    view.validate();
                    view.repaint();
                }
            }
            if (stop2) {
                this.setCursor(content, Cursor.getPredefinedCursor(0));
                this.myLocation = null;
            }
            event.consume();
        } else if (stop2 && this.myViewBounds != null) {
            this.myViewBounds = null;
            event.consume();
        }
    }

    protected Component getContent(MouseEvent event) {
        return this.myContent != null ? this.myContent : event.getComponent();
    }

    protected Component getView(Component component) {
        return UIUtil.getWindow((Component)component);
    }

    protected void setCursor(Component content, Cursor cursor) {
        content.setCursor(cursor);
    }

    public boolean isBusy() {
        return this.myLocation != null;
    }
}

