/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.impl.facade.GraphChanges;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphChangesUtil {
    public static final GraphChanges<Integer> SOME_CHANGES = new GraphChanges<Integer>(){

        @Override
        @NotNull
        public Collection<GraphChanges.Node<Integer>> getChangedNodes() {
            List<GraphChanges.Node<Integer>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/GraphChangesUtil$1", "getChangedNodes"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<GraphChanges.Edge<Integer>> getChangedEdges() {
            List<GraphChanges.Edge<Integer>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/GraphChangesUtil$1", "getChangedEdges"));
            }
            return list;
        }
    };

    public static GraphChanges.EdgeImpl<Integer> edgeChanged(@NotNull GraphEdge edge, @NotNull LinearGraph graph, boolean removed) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/impl/facade/GraphChangesUtil", "edgeChanged"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/facade/GraphChangesUtil", "edgeChanged"));
        }
        Integer up = null;
        Integer down = null;
        if (edge.getUpNodeIndex() != null) {
            up = graph.getNodeId(edge.getUpNodeIndex());
        }
        if (edge.getDownNodeIndex() != null) {
            down = graph.getNodeId(edge.getDownNodeIndex());
        }
        return new GraphChanges.EdgeImpl<Integer>(up, down, edge.getTargetId(), removed);
    }

    public static GraphChanges<Integer> edgesReplaced(Collection<GraphEdge> removedEdges, Collection<GraphEdge> addedEdges, LinearGraph delegateGraph) {
        HashSet edgeChanges = ContainerUtil.newHashSet();
        for (GraphEdge edge : removedEdges) {
            edgeChanges.add(GraphChangesUtil.edgeChanged(edge, delegateGraph, true));
        }
        for (GraphEdge edge : addedEdges) {
            edgeChanges.add(GraphChangesUtil.edgeChanged(edge, delegateGraph, false));
        }
        return new GraphChanges.GraphChangesImpl<Integer>(Collections.emptySet(), edgeChanges);
    }
}

