/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.impl.facade.bek.BekSorter;
import icons.VcsLogIcons;
import org.jetbrains.annotations.NotNull;

public class IntelliSortChooserToggleAction
extends ToggleAction
implements DumbAware {
    @NotNull
    private static final String DEFAULT_TEXT = "IntelliSort";
    @NotNull
    private static final String DEFAULT_DESCRIPTION = "Turn IntelliSort On/Off";

    public IntelliSortChooserToggleAction() {
        super(DEFAULT_TEXT, DEFAULT_DESCRIPTION, VcsLogIcons.IntelliSort);
    }

    public boolean isSelected(AnActionEvent e) {
        VcsLogUi logUI = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        return logUI != null && !logUI.getBekType().equals((Object)PermanentGraph.SortType.Normal);
    }

    public void setSelected(AnActionEvent e, boolean state) {
        VcsLogUi logUI = (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        logUI.setBekType(state ? PermanentGraph.SortType.Bek : PermanentGraph.SortType.Normal);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/IntelliSortChooserToggleAction", "update"));
        }
        super.update(e);
        VcsLogUi logUI = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        e.getPresentation().setVisible(BekSorter.isBekEnabled());
        e.getPresentation().setEnabled(BekSorter.isBekEnabled() && logUI != null);
        if (logUI != null) {
            boolean off = logUI.getBekType() == PermanentGraph.SortType.Normal;
            e.getPresentation().setText("IntelliSort is " + (off ? "Off" : "On"));
            e.getPresentation().setDescription("Turn IntelliSort " + (off ? "on" : "off") + " (" + (off ? PermanentGraph.SortType.Bek.getDescription().toLowerCase() : PermanentGraph.SortType.Normal.getDescription().toLowerCase()) + ").");
        } else {
            e.getPresentation().setText(DEFAULT_TEXT);
            e.getPresentation().setDescription(DEFAULT_DESCRIPTION);
        }
    }
}

