/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import org.jetbrains.annotations.NotNull;

public class XDebuggerRunToCursorActionHandler
extends XDebuggerSuspendedActionHandler {
    private final boolean myIgnoreBreakpoints;

    public XDebuggerRunToCursorActionHandler(boolean ignoreBreakpoints) {
        this.myIgnoreBreakpoints = ignoreBreakpoints;
    }

    @Override
    protected boolean isEnabled(@NotNull XDebugSession session, DataContext dataContext) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerRunToCursorActionHandler", "isEnabled"));
        }
        return super.isEnabled(session, dataContext) && XDebuggerUtilImpl.getCaretPosition(session.getProject(), dataContext) != null;
    }

    @Override
    protected void perform(@NotNull XDebugSession session, DataContext dataContext) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerRunToCursorActionHandler", "perform"));
        }
        XSourcePosition position = XDebuggerUtilImpl.getCaretPosition(session.getProject(), dataContext);
        if (position != null) {
            session.runToPosition(position, this.myIgnoreBreakpoints);
        }
    }
}

