/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.arrangement;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.Stack;
import com.intellij.xml.arrangement.XmlArrangementParseInfo;
import com.intellij.xml.arrangement.XmlElementArrangementEntry;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlArrangementVisitor
extends XmlElementVisitor {
    private final Stack<XmlElementArrangementEntry> myStack;
    private final XmlArrangementParseInfo myInfo;
    private final Collection<TextRange> myRanges;

    public XmlArrangementVisitor(@NotNull XmlArrangementParseInfo info, @NotNull Collection<TextRange> ranges) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/xml/arrangement/XmlArrangementVisitor", "<init>"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/xml/arrangement/XmlArrangementVisitor", "<init>"));
        }
        this.myStack = new Stack();
        this.myInfo = info;
        this.myRanges = ranges;
    }

    public void visitXmlFile(XmlFile file2) {
        XmlTag tag = file2.getRootTag();
        if (tag != null) {
            tag.accept((PsiElementVisitor)this);
        }
    }

    public void visitXmlTag(XmlTag tag) {
        XmlElementArrangementEntry entry = this.createNewEntry(tag.getTextRange(), StdArrangementTokens.EntryType.XML_TAG, null, null, true);
        this.processEntry(entry, (PsiElement)tag);
    }

    public void visitXmlAttribute(XmlAttribute attribute) {
        XmlElementArrangementEntry entry = this.createNewEntry(attribute.getTextRange(), (ArrangementSettingsToken)StdArrangementTokens.EntryType.XML_ATTRIBUTE, attribute.getName(), attribute.getNamespace(), true);
        this.processEntry(entry, null);
    }

    private void processEntry(@Nullable XmlElementArrangementEntry entry, @Nullable PsiElement nextElement) {
        if (entry == null || nextElement == null) {
            return;
        }
        this.myStack.push((Object)entry);
        try {
            nextElement.acceptChildren((PsiElementVisitor)this);
        }
        finally {
            this.myStack.pop();
        }
    }

    @Nullable
    private XmlElementArrangementEntry createNewEntry(@NotNull TextRange range, @NotNull ArrangementSettingsToken type, @Nullable String name, @Nullable String namespace, boolean canBeMatched) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/xml/arrangement/XmlArrangementVisitor", "createNewEntry"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xml/arrangement/XmlArrangementVisitor", "createNewEntry"));
        }
        if (range.getStartOffset() == 0 && range.getEndOffset() == 0 || !this.isWithinBounds(range)) {
            return null;
        }
        DefaultArrangementEntry current = this.getCurrent();
        XmlElementArrangementEntry entry = new XmlElementArrangementEntry((ArrangementEntry)current, range, type, name, namespace, canBeMatched);
        if (current == null) {
            this.myInfo.addEntry(entry);
        } else {
            current.addChild((ArrangementEntry)entry);
        }
        return entry;
    }

    @Nullable
    private DefaultArrangementEntry getCurrent() {
        return this.myStack.isEmpty() ? null : (XmlElementArrangementEntry)((Object)this.myStack.peek());
    }

    private boolean isWithinBounds(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/xml/arrangement/XmlArrangementVisitor", "isWithinBounds"));
        }
        for (TextRange textRange : this.myRanges) {
            if (!textRange.intersects(range)) continue;
            return true;
        }
        return false;
    }
}

