/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.arrangement;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NamespaceAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TypeAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementArrangementEntry
extends DefaultArrangementEntry
implements TypeAwareArrangementEntry,
NameAwareArrangementEntry,
NamespaceAwareArrangementEntry {
    private final ArrangementSettingsToken myType;
    private final String myName;
    private final String myNamespace;

    public XmlElementArrangementEntry(@Nullable ArrangementEntry parent, @NotNull TextRange range, @NotNull ArrangementSettingsToken type, @Nullable String name, @Nullable String namespace, boolean canBeMatched) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/xml/arrangement/XmlElementArrangementEntry", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xml/arrangement/XmlElementArrangementEntry", "<init>"));
        }
        super(parent, range.getStartOffset(), range.getEndOffset(), canBeMatched);
        this.myName = name;
        this.myNamespace = namespace;
        this.myType = type;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getNamespace() {
        return this.myNamespace;
    }

    @NotNull
    public Set<ArrangementSettingsToken> getTypes() {
        Set<ArrangementSettingsToken> set = Collections.singleton(this.myType);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/arrangement/XmlElementArrangementEntry", "getTypes"));
        }
        return set;
    }
}

