/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.duplicates.ConditionalReturnStatementValue;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IfStatementWithIdenticalBranchesInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("if.statement.with.identical.branches.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("if.statement.with.identical.branches.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new CollapseIfFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfStatementWithIdenticalBranchesVisitor();
    }

    private static class IfStatementWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private IfStatementWithIdenticalBranchesVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$IfStatementWithIdenticalBranchesVisitor", "visitIfStatement"));
            }
            super.visitIfStatement(ifStatement);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            Project project = ifStatement.getProject();
            InputVariables inputVariables = new InputVariables(Collections.emptyList(), project, new LocalSearchScope((PsiElement)thenBranch), false);
            DuplicatesFinder finder = new DuplicatesFinder(new PsiElement[]{thenBranch}, inputVariables, null, Collections.emptyList());
            if (elseBranch instanceof PsiIfStatement) {
                PsiIfStatement statement = (PsiIfStatement)elseBranch;
                PsiStatement branch = statement.getThenBranch();
                if (branch == null) {
                    return;
                }
                Match match = finder.isDuplicate((PsiElement)branch, true);
                if (match != null) {
                    ReturnValue matchReturnValue = match.getReturnValue();
                    if (matchReturnValue instanceof ConditionalReturnStatementValue && !matchReturnValue.isEquivalent(this.buildReturnValue((PsiElement)thenBranch))) {
                        return;
                    }
                    this.registerStatementError((PsiStatement)ifStatement, statement);
                    return;
                }
            }
            if (elseBranch == null) {
                this.checkIfStatementWithoutElseBranch(ifStatement);
            } else {
                Match match = finder.isDuplicate((PsiElement)elseBranch, true);
                if (match != null) {
                    ReturnValue matchReturnValue = match.getReturnValue();
                    if (matchReturnValue instanceof ConditionalReturnStatementValue && !matchReturnValue.isEquivalent(this.buildReturnValue((PsiElement)thenBranch))) {
                        return;
                    }
                    this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
                }
            }
        }

        @Nullable
        private ReturnValue buildReturnValue(PsiElement element) {
            final Ref result2 = Ref.create(null);
            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitClass(PsiClass aClass) {
                }

                public void visitLambdaExpression(PsiLambdaExpression expression) {
                }

                public void visitReturnStatement(PsiReturnStatement statement) {
                    super.visitReturnStatement(statement);
                    result2.set((Object)statement);
                }
            });
            PsiReturnStatement returnStatement = (PsiReturnStatement)result2.get();
            if (returnStatement == null) {
                return null;
            }
            PsiExpression expression = returnStatement.getReturnValue();
            if (expression == null) {
                return null;
            }
            return new ConditionalReturnStatementValue(expression);
        }

        private void checkIfStatementWithoutElseBranch(PsiIfStatement ifStatement) {
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                return;
            }
            PsiStatement nextStatement = IfStatementWithIdenticalBranchesVisitor.getNextStatement((PsiStatement)ifStatement);
            if (thenBranch instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                PsiStatement lastStatement = statements[statements.length - 1];
                for (PsiStatement statement : statements) {
                    if (nextStatement == null) {
                        PsiReturnStatement returnStatement;
                        if (statement == lastStatement && statement instanceof PsiReturnStatement && (returnStatement = (PsiReturnStatement)statement).getReturnValue() == null) {
                            this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
                        }
                        return;
                    }
                    if (!EquivalenceChecker.statementsAreEquivalent(statement, nextStatement)) {
                        return;
                    }
                    nextStatement = IfStatementWithIdenticalBranchesVisitor.getNextStatement(nextStatement);
                }
            } else if (!EquivalenceChecker.statementsAreEquivalent(thenBranch, nextStatement)) {
                return;
            }
            this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
        }

        @Nullable
        private static PsiStatement getNextStatement(PsiStatement statement) {
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
            while (nextStatement == null) {
                PsiElement nextStatementParent;
                PsiElement statementParent;
                if ((statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiStatement.class)) == null) {
                    return null;
                }
                if (statement instanceof PsiLoopStatement) {
                    return statement;
                }
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
                if (nextStatement == null || !((statementParent = statement.getParent()) instanceof PsiIfStatement) || !statementParent.equals(nextStatementParent = nextStatement.getParent())) continue;
                nextStatement = null;
            }
            return nextStatement;
        }
    }

    private static class CollapseIfFix
    extends InspectionGadgetsFix {
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("if.statement.with.identical.branches.collapse.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$CollapseIfFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$CollapseIfFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$CollapseIfFix", "doFix"));
            }
            PsiElement identifier = descriptor.getPsiElement();
            PsiIfStatement statement = (PsiIfStatement)identifier.getParent();
            assert (statement != null);
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiStatement elseBranch = statement.getElseBranch();
            if (elseBranch == null) {
                statement.delete();
                return;
            }
            if (elseBranch instanceof PsiIfStatement) {
                PsiIfStatement elseIfStatement = (PsiIfStatement)elseBranch;
                PsiExpression condition1 = statement.getCondition();
                PsiExpression condition2 = elseIfStatement.getCondition();
                if (condition1 == null) {
                    return;
                }
                PsiReplacementUtil.replaceExpression(condition1, CollapseIfFix.buildOrExpressionText(condition1, condition2));
                PsiStatement elseElseBranch = elseIfStatement.getElseBranch();
                if (elseElseBranch == null) {
                    elseIfStatement.delete();
                } else {
                    elseIfStatement.replace((PsiElement)elseElseBranch);
                }
            } else {
                PsiElement parent = statement.getParent();
                if (thenBranch instanceof PsiBlockStatement) {
                    PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                    if (parent instanceof PsiCodeBlock) {
                        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                        PsiStatement[] statements = codeBlock.getStatements();
                        if (statements.length > 0) {
                            parent.addRangeBefore((PsiElement)statements[0], (PsiElement)statements[statements.length - 1], (PsiElement)statement);
                        }
                        statement.delete();
                    } else {
                        statement.replace((PsiElement)blockStatement);
                    }
                } else {
                    statement.replace((PsiElement)thenBranch);
                }
            }
        }

        private static String buildOrExpressionText(PsiExpression expression1, PsiExpression expression2) {
            StringBuilder result2 = new StringBuilder();
            if (expression1 != null) {
                result2.append(expression1.getText());
            }
            result2.append("||");
            if (expression2 != null) {
                result2.append(expression2.getText());
            }
            return result2.toString();
        }
    }
}

