/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeParameterExtendsFinalClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("type.parameter.extends.final.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer problemType = (Integer)infos[1];
        PsiNamedElement namedElement = (PsiNamedElement)infos[0];
        String name = namedElement.getName();
        if (problemType == 1) {
            String string = InspectionGadgetsBundle.message("type.parameter.extends.final.class.problem.descriptor1", name);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("type.parameter.extends.final.class.problem.descriptor2", name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new TypeParameterExtendsFinalClassFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TypeParameterExtendsFinalClassVisitor();
    }

    private static class TypeParameterExtendsFinalClassVisitor
    extends BaseInspectionVisitor {
        private TypeParameterExtendsFinalClassVisitor() {
        }

        public void visitTypeParameter(PsiTypeParameter classParameter) {
            super.visitTypeParameter(classParameter);
            PsiClassType[] extendsListTypes = classParameter.getExtendsListTypes();
            if (extendsListTypes.length < 1) {
                return;
            }
            PsiClassType extendsType = extendsListTypes[0];
            PsiClass aClass = extendsType.resolve();
            if (aClass == null || !aClass.hasModifierProperty("final")) {
                return;
            }
            PsiIdentifier nameIdentifier = classParameter.getNameIdentifier();
            if (nameIdentifier != null) {
                this.registerError((PsiElement)nameIdentifier, aClass, 1);
            }
        }

        public void visitTypeElement(PsiTypeElement typeElement) {
            super.visitTypeElement(typeElement);
            PsiType type = typeElement.getType();
            if (!(type instanceof PsiWildcardType)) {
                return;
            }
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            PsiType extendsBound = wildcardType.getExtendsBound();
            if (!(extendsBound instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)extendsBound;
            PsiClass aClass = classType.resolve();
            if (aClass == null || !aClass.hasModifierProperty("final")) {
                return;
            }
            if (aClass.hasTypeParameters() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)typeElement)) {
                PsiType[] parameters = classType.getParameters();
                if (parameters.length == 0) {
                    return;
                }
                for (PsiType parameter : parameters) {
                    if (!(parameter instanceof PsiWildcardType)) continue;
                    return;
                }
            }
            if (!TypeParameterExtendsFinalClassVisitor.shouldReport(typeElement)) {
                return;
            }
            this.registerError(typeElement.getFirstChild(), aClass, 2);
        }

        private static boolean shouldReport(PsiTypeElement typeElement) {
            PsiElement ancestor = PsiTreeUtil.skipParentsOfType((PsiElement)typeElement, (Class[])new Class[]{PsiTypeElement.class, PsiJavaCodeReferenceElement.class, PsiReferenceParameterList.class});
            if (ancestor instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)ancestor;
                PsiElement scope = parameter.getDeclarationScope();
                if (scope instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)scope;
                    if (MethodUtils.hasSuper(method)) {
                        return false;
                    }
                } else if (scope instanceof PsiForeachStatement) {
                    PsiForeachStatement foreachStatement = (PsiForeachStatement)scope;
                    PsiParameter iterationParameter = foreachStatement.getIterationParameter();
                    PsiType iterationType = iterationParameter.getType();
                    PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                    if (iteratedValue == null) {
                        return false;
                    }
                    PsiType type = JavaGenericsUtil.getCollectionItemType(iteratedValue);
                    if (type == null || !TypeConversionUtil.isAssignable((PsiType)iterationType, (PsiType)type)) {
                        return false;
                    }
                    if (type.equals(iterationType)) {
                        return false;
                    }
                    if (!(type instanceof PsiCapturedWildcardType)) {
                        return true;
                    }
                    PsiCapturedWildcardType capturedWildcardType = (PsiCapturedWildcardType)type;
                    PsiType upperBound = capturedWildcardType.getUpperBound();
                    if (iterationType.equals(upperBound)) {
                        return false;
                    }
                }
            } else if (ancestor instanceof PsiLocalVariable) {
                PsiLocalVariable localVariable = (PsiLocalVariable)ancestor;
                PsiExpression initializer = localVariable.getInitializer();
                if (initializer == null) {
                    return true;
                }
                PsiType type = initializer.getType();
                PsiType expectedType = GenericsUtil.getVariableTypeByExpressionType((PsiType)type);
                PsiType variableType = localVariable.getType();
                if (variableType.equals(expectedType)) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class TypeParameterExtendsFinalClassFix
    extends InspectionGadgetsFix {
        private TypeParameterExtendsFinalClassFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection$TypeParameterExtendsFinalClassFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("type.parameter.extends.final.class.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection$TypeParameterExtendsFinalClassFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(@NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection$TypeParameterExtendsFinalClassFix", "doFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)parent;
                TypeParameterExtendsFinalClassFix.replaceTypeParameterUsagesWithType(typeParameter);
                typeParameter.delete();
            } else if (parent instanceof PsiTypeElement) {
                PsiTypeElement typeElement = (PsiTypeElement)parent;
                PsiElement lastChild = typeElement.getLastChild();
                if (lastChild == null) {
                    return;
                }
                typeElement.replace(lastChild);
            }
        }

        private static void replaceTypeParameterUsagesWithType(PsiTypeParameter typeParameter) {
            PsiClassType[] types = typeParameter.getExtendsList().getReferencedTypes();
            if (types.length < 1) {
                return;
            }
            Project project = typeParameter.getProject();
            PsiJavaCodeReferenceElement classReference = JavaPsiFacade.getElementFactory((Project)project).createReferenceElementByType(types[0]);
            Query query = ReferencesSearch.search((PsiElement)typeParameter, (SearchScope)typeParameter.getUseScope());
            for (PsiReference reference : query) {
                PsiElement referenceElement = reference.getElement();
                referenceElement.replace((PsiElement)classReference);
            }
        }
    }
}

