/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class ClassWithoutConstructorInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.without.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javabeans/ClassWithoutConstructorInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.without.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javabeans/ClassWithoutConstructorInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ClassWithoutConstructorFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithoutConstructorVisitor();
    }

    private static class ClassWithoutConstructorVisitor
    extends BaseInspectionVisitor {
        private ClassWithoutConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/javabeans/ClassWithoutConstructorInspection$ClassWithoutConstructorVisitor", "visitClass"));
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
                return;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length > 0) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }

    private static class ClassWithoutConstructorFix
    extends InspectionGadgetsFix {
        private ClassWithoutConstructorFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("class.without.constructor.create.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javabeans/ClassWithoutConstructorInspection$ClassWithoutConstructorFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javabeans/ClassWithoutConstructorInspection$ClassWithoutConstructorFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement classIdentifier = descriptor.getPsiElement();
            PsiClass aClass = (PsiClass)classIdentifier.getParent();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiMethod constructor = factory.createConstructor();
            PsiModifierList modifierList = constructor.getModifierList();
            if (aClass == null) {
                return;
            }
            if (aClass.hasModifierProperty("private")) {
                modifierList.setModifierProperty("public", false);
                modifierList.setModifierProperty("private", true);
            } else if (aClass.hasModifierProperty("protected")) {
                modifierList.setModifierProperty("public", false);
                modifierList.setModifierProperty("protected", true);
            } else if (aClass.hasModifierProperty("abstract")) {
                modifierList.setModifierProperty("public", false);
                modifierList.setModifierProperty("protected", true);
            } else if (!aClass.hasModifierProperty("public")) {
                modifierList.setModifierProperty("public", false);
            }
            aClass.add((PsiElement)constructor);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
            styleManager.reformat((PsiElement)constructor);
        }
    }
}

