/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("BeforeOrAfterWithIncorrectSignature" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase", "getID"));
        }
        return "BeforeOrAfterWithIncorrectSignature";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("before.class.or.after.class.is.public.static.void.no.arg.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("before.class.or.after.class.is.public.static.void.no.arg.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor();
    }

    private static class BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase$BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor", "visitMethod"));
            }
            if (!TestUtils.isJUnit4BeforeClassOrAfterClassMethod(method)) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass targetClass = method.getContainingClass();
            if (targetClass == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (!(parameterList.getParametersCount() == 0 && returnType.equals(PsiType.VOID) && method.hasModifierProperty("public") && method.hasModifierProperty("static"))) {
                this.registerMethodError(method, "Change signature of '" + PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)267, (int)2) + "' to 'public static void " + method.getName() + "()'");
            }
        }
    }
}

