/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ThrowablePrintedToSystemOutInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("throwable.printed.to.system.out.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/ThrowablePrintedToSystemOutInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String fieldName = (String)infos[0];
        String methodName = (String)infos[1];
        String string = InspectionGadgetsBundle.message("throwable.printed.to.system.out.problem.descriptor", fieldName, methodName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/ThrowablePrintedToSystemOutInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowablePrintedToSystemOutVisitor();
    }

    private static class ThrowablePrintedToSystemOutVisitor
    extends BaseInspectionVisitor {
        private ThrowablePrintedToSystemOutVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"print".equals(methodName) && !"println".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (!TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Throwable")) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression qualifierReference = (PsiReferenceExpression)qualifier;
            PsiElement target = qualifierReference.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            String fieldName = field.getName();
            if (!"out".equals(fieldName) && !"err".equals(fieldName)) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null || !"java.lang.System".equals(aClass.getQualifiedName())) {
                return;
            }
            this.registerError((PsiElement)argument, fieldName, methodName);
        }
    }
}

