/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.equality;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ipp.base.PsiElementPredicate;

class ObjectEqualityPredicate
implements PsiElementPredicate {
    ObjectEqualityPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression expression = (PsiBinaryExpression)element;
        IElementType tokenType = expression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.NE) && !tokenType.equals(JavaTokenType.EQEQ)) {
            return false;
        }
        PsiExpression lhs = expression.getLOperand();
        PsiType lhsType = lhs.getType();
        if (lhsType == null || lhsType instanceof PsiPrimitiveType || TypeConversionUtil.isEnumType((PsiType)lhsType)) {
            return false;
        }
        PsiExpression rhs = expression.getROperand();
        if (rhs == null) {
            return false;
        }
        PsiType rhsType = rhs.getType();
        return rhsType != null && !(rhsType instanceof PsiPrimitiveType) && !TypeConversionUtil.isEnumType((PsiType)rhsType);
    }
}

