/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class MergeParallelIfsPredicate
implements PsiElementPredicate {
    MergeParallelIfsPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiStatement thenBranch;
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiElement parent = token.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement nextIfStatement = (PsiIfStatement)nextStatement;
        if (ErrorUtil.containsError((PsiElement)ifStatement)) {
            return false;
        }
        if (ErrorUtil.containsError((PsiElement)nextIfStatement)) {
            return false;
        }
        if (!MergeParallelIfsPredicate.ifStatementsCanBeMerged(ifStatement, nextIfStatement)) {
            return false;
        }
        PsiExpression condition = ifStatement.getCondition();
        Set<PsiVariable> variables = VariableAccessUtils.collectUsedVariables((PsiElement)condition);
        if (VariableAccessUtils.isAnyVariableAssigned(variables, (PsiElement)(thenBranch = ifStatement.getThenBranch()))) {
            return false;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        return !VariableAccessUtils.isAnyVariableAssigned(variables, (PsiElement)elseBranch);
    }

    public static boolean ifStatementsCanBeMerged(PsiIfStatement statement1, PsiIfStatement statement2) {
        PsiExpression secondCondition;
        PsiStatement thenBranch = statement1.getThenBranch();
        PsiStatement elseBranch = statement1.getElseBranch();
        if (thenBranch == null) {
            return false;
        }
        PsiExpression firstCondition = statement1.getCondition();
        if (!EquivalenceChecker.expressionsAreEquivalent(firstCondition, secondCondition = statement2.getCondition())) {
            return false;
        }
        PsiStatement nextThenBranch = statement2.getThenBranch();
        if (!MergeParallelIfsPredicate.canBeMerged(thenBranch, nextThenBranch)) {
            return false;
        }
        PsiStatement nextElseBranch = statement2.getElseBranch();
        return elseBranch == null || nextElseBranch == null || MergeParallelIfsPredicate.canBeMerged(elseBranch, nextElseBranch);
    }

    private static boolean canBeMerged(PsiStatement statement1, PsiStatement statement2) {
        if (!ControlFlowUtils.statementMayCompleteNormally(statement1)) {
            return false;
        }
        Set<String> statement1Declarations = MergeParallelIfsPredicate.calculateTopLevelDeclarations(statement1);
        if (MergeParallelIfsPredicate.containsConflictingDeclarations(statement1Declarations, (PsiElement)statement2)) {
            return false;
        }
        Set<String> statement2Declarations = MergeParallelIfsPredicate.calculateTopLevelDeclarations(statement2);
        return !MergeParallelIfsPredicate.containsConflictingDeclarations(statement2Declarations, (PsiElement)statement1);
    }

    private static boolean containsConflictingDeclarations(Set<String> declarations, PsiElement context) {
        DeclarationVisitor visitor = new DeclarationVisitor(declarations);
        context.accept((PsiElementVisitor)visitor);
        return visitor.hasConflict();
    }

    private static Set<String> calculateTopLevelDeclarations(PsiStatement statement) {
        HashSet<String> out = new HashSet<String>();
        if (statement instanceof PsiDeclarationStatement) {
            MergeParallelIfsPredicate.addDeclarations((PsiDeclarationStatement)statement, out);
        } else if (statement instanceof PsiBlockStatement) {
            PsiStatement[] statements;
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
            PsiCodeBlock block = blockStatement.getCodeBlock();
            for (PsiStatement statement1 : statements = block.getStatements()) {
                if (!(statement1 instanceof PsiDeclarationStatement)) continue;
                MergeParallelIfsPredicate.addDeclarations((PsiDeclarationStatement)statement1, out);
            }
        }
        return out;
    }

    private static void addDeclarations(PsiDeclarationStatement statement, Collection<String> declaredVariables) {
        PsiElement[] elements;
        for (PsiElement element : elements = statement.getDeclaredElements()) {
            if (!(element instanceof PsiVariable)) continue;
            PsiVariable variable = (PsiVariable)element;
            String name = variable.getName();
            declaredVariables.add(name);
        }
    }

    private static class DeclarationVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<String> declarations;
        private boolean hasConflict = false;

        private DeclarationVisitor(Set<String> declarations) {
            this.declarations = new HashSet<String>(declarations);
        }

        public void visitVariable(PsiVariable variable) {
            super.visitVariable(variable);
            String name = variable.getName();
            for (String declaration : this.declarations) {
                String testName = declaration;
                if (!testName.equals(name)) continue;
                this.hasConflict = true;
            }
        }

        public boolean hasConflict() {
            return this.hasConflict;
        }
    }
}

