/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PsiActionSupportFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.intellij.images.ImagesBundle;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.options.ZoomOptions;
import org.intellij.images.ui.ImageComponent;
import org.intellij.images.ui.ImageComponentDecorator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImageEditorUI
extends JPanel
implements DataProvider,
CopyProvider,
ImageComponentDecorator,
Disposable {
    @NonNls
    private static final String IMAGE_PANEL = "image";
    @NonNls
    private static final String ERROR_PANEL = "error";
    @Nullable
    private final ImageEditor editor;
    private final DeleteProvider deleteProvider;
    private final CopyPasteSupport copyPasteSupport;
    private final ImageZoomModel zoomModel = new ImageZoomModelImpl();
    private final ImageWheelAdapter wheelAdapter = new ImageWheelAdapter();
    private final ChangeListener changeListener = new DocumentChangeListener();
    private final ImageComponent imageComponent = new ImageComponent();
    private final JPanel contentPanel;
    private final JLabel infoLabel;
    private final PropertyChangeListener optionsChangeListener = new OptionsChangeListener();

    ImageEditorUI(@Nullable ImageEditor editor) {
        this.editor = editor;
        Options options = OptionsManager.getInstance().getOptions();
        EditorOptions editorOptions = options.getEditorOptions();
        options.addPropertyChangeListener(this.optionsChangeListener);
        PsiActionSupportFactory factory = PsiActionSupportFactory.getInstance();
        this.copyPasteSupport = factory != null && editor != null ? factory.createPsiBasedCopyPasteSupport(editor.getProject(), (JComponent)this, new PsiActionSupportFactory.PsiElementSelector(){

            public PsiElement[] getSelectedElements() {
                PsiElement[] data = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData((DataProvider)ImageEditorUI.this);
                return data == null ? PsiElement.EMPTY_ARRAY : data;
            }
        }) : null;
        this.deleteProvider = factory == null ? null : factory.createPsiBasedDeleteProvider();
        ImageDocument document = this.imageComponent.getDocument();
        document.addChangeListener(this.changeListener);
        TransparencyChessboardOptions chessboardOptions = editorOptions.getTransparencyChessboardOptions();
        GridOptions gridOptions = editorOptions.getGridOptions();
        this.imageComponent.setTransparencyChessboardCellSize(chessboardOptions.getCellSize());
        this.imageComponent.setTransparencyChessboardWhiteColor(chessboardOptions.getWhiteColor());
        this.imageComponent.setTransparencyChessboardBlankColor(chessboardOptions.getBlackColor());
        this.imageComponent.setGridLineZoomFactor(gridOptions.getLineZoomFactor());
        this.imageComponent.setGridLineSpan(gridOptions.getLineSpan());
        this.imageComponent.setGridLineColor(gridOptions.getLineColor());
        ImageContainerPane view = new ImageContainerPane(this.imageComponent);
        view.addMouseListener((MouseListener)((Object)new EditorMouseAdapter()));
        view.addMouseListener(new FocusRequester());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)view));
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.addMouseWheelListener(this.wheelAdapter);
        this.setLayout(new BorderLayout());
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup actionGroup = (ActionGroup)actionManager.getAction("Images.EditorToolbar");
        ActionToolbar actionToolbar = actionManager.createActionToolbar("Images.Editor", actionGroup, true);
        actionToolbar.updateActionsImmediately();
        actionToolbar.setTargetComponent((JComponent)this);
        JComponent toolbarPanel = actionToolbar.getComponent();
        toolbarPanel.addMouseListener(new FocusRequester());
        JLabel errorLabel = new JLabel(ImagesBundle.message("error.broken.image.file.format", new Object[0]), Messages.getErrorIcon(), 0);
        JPanel errorPanel = new JPanel(new BorderLayout());
        errorPanel.add((Component)errorLabel, "Center");
        this.contentPanel = new JPanel(new CardLayout());
        this.contentPanel.add((Component)scrollPane, IMAGE_PANEL);
        this.contentPanel.add((Component)errorPanel, ERROR_PANEL);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)toolbarPanel, "West");
        this.infoLabel = new JLabel((String)null, 4);
        this.infoLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)2));
        topPanel.add((Component)this.infoLabel, "East");
        this.add((Component)topPanel, "North");
        this.add((Component)this.contentPanel, "Center");
        this.updateInfo();
    }

    private void updateInfo() {
        ImageDocument document = this.imageComponent.getDocument();
        BufferedImage image = document.getValue();
        if (image != null) {
            ColorModel colorModel = image.getColorModel();
            String format = document.getFormat();
            format = format == null ? (this.editor != null ? ImagesBundle.message("unknown.format", new Object[0]) : "") : format.toUpperCase(Locale.ENGLISH);
            VirtualFile file2 = this.editor != null ? this.editor.getFile() : null;
            this.infoLabel.setText(ImagesBundle.message("image.info", image.getWidth(), image.getHeight(), format, colorModel.getPixelSize(), file2 != null ? StringUtil.formatFileSize((long)file2.getLength()) : ""));
        } else {
            this.infoLabel.setText(null);
        }
    }

    JComponent getContentComponent() {
        return this.contentPanel;
    }

    ImageComponent getImageComponent() {
        return this.imageComponent;
    }

    public void dispose() {
        Options options = OptionsManager.getInstance().getOptions();
        options.removePropertyChangeListener(this.optionsChangeListener);
        this.imageComponent.removeMouseWheelListener(this.wheelAdapter);
        this.imageComponent.getDocument().removeChangeListener(this.changeListener);
        this.removeAll();
    }

    @Override
    public void setTransparencyChessboardVisible(boolean visible) {
        this.imageComponent.setTransparencyChessboardVisible(visible);
    }

    @Override
    public boolean isTransparencyChessboardVisible() {
        return this.imageComponent.isTransparencyChessboardVisible();
    }

    @Override
    public boolean isEnabledForActionPlace(String place) {
        return !"Images.Thumbnails".equals(place);
    }

    @Override
    public void setGridVisible(boolean visible) {
        this.imageComponent.setGridVisible(visible);
    }

    @Override
    public boolean isGridVisible() {
        return this.imageComponent.isGridVisible();
    }

    @Override
    public ImageZoomModel getZoomModel() {
        return this.zoomModel;
    }

    public void setImage(BufferedImage image, String format) {
        ImageDocument document = this.imageComponent.getDocument();
        BufferedImage previousImage = document.getValue();
        document.setValue(image);
        if (image == null) {
            return;
        }
        document.setFormat(format);
        ImageZoomModel zoomModel = this.getZoomModel();
        if (previousImage == null || !zoomModel.isZoomLevelChanged()) {
            Options options = OptionsManager.getInstance().getOptions();
            ZoomOptions zoomOptions = options.getEditorOptions().getZoomOptions();
            zoomModel.setZoomFactor(1.0);
            if (zoomOptions.isSmartZooming()) {
                Dimension prefferedSize = zoomOptions.getPrefferedSize();
                if (prefferedSize.width > image.getWidth() && prefferedSize.height > image.getHeight()) {
                    double factor = (prefferedSize.getWidth() / (double)image.getWidth() + prefferedSize.getHeight() / (double)image.getHeight()) / 2.0;
                    zoomModel.setZoomFactor(Math.ceil(factor));
                }
            }
        }
    }

    @Nullable
    public Object getData(String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.editor != null ? this.editor.getProject() : null;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.editor != null ? this.editor.getFile() : null;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            VirtualFile[] virtualFileArray;
            if (this.editor != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = this.editor.getFile();
            } else {
                virtualFileArray = new VirtualFile[]{};
            }
            return virtualFileArray;
        }
        if (CommonDataKeys.PSI_FILE.is(dataId)) {
            return this.getData(CommonDataKeys.PSI_ELEMENT.getName());
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            VirtualFile file2 = this.editor != null ? this.editor.getFile() : null;
            return file2 != null && file2.isValid() ? PsiManager.getInstance((Project)this.editor.getProject()).findFile(file2) : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            PsiElement[] psiElementArray;
            if (this.editor != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = (PsiElement)this.getData(CommonDataKeys.PSI_ELEMENT.getName());
            } else {
                psiElementArray = new PsiElement[]{};
            }
            return psiElementArray;
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId) && this.copyPasteSupport != null) {
            return this;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId) && this.copyPasteSupport != null) {
            return this.copyPasteSupport.getCutProvider();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.deleteProvider;
        }
        if (ImageComponentDecorator.DATA_KEY.is(dataId)) {
            return this.editor != null ? this.editor : this;
        }
        return null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "org/intellij/images/editor/impl/ImageEditorUI", "performCopy"));
        }
        ImageDocument document = this.imageComponent.getDocument();
        BufferedImage image = document.getValue();
        CopyPasteManager.getInstance().setContents((Transferable)new ImageTransferable(image));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "org/intellij/images/editor/impl/ImageEditorUI", "isCopyEnabled"));
        }
        return true;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "org/intellij/images/editor/impl/ImageEditorUI", "isCopyVisible"));
        }
        return true;
    }

    private class OptionsChangeListener
    implements PropertyChangeListener {
        private OptionsChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Options options = (Options)evt.getSource();
            EditorOptions editorOptions = options.getEditorOptions();
            TransparencyChessboardOptions chessboardOptions = editorOptions.getTransparencyChessboardOptions();
            GridOptions gridOptions = editorOptions.getGridOptions();
            ImageEditorUI.this.imageComponent.setTransparencyChessboardCellSize(chessboardOptions.getCellSize());
            ImageEditorUI.this.imageComponent.setTransparencyChessboardWhiteColor(chessboardOptions.getWhiteColor());
            ImageEditorUI.this.imageComponent.setTransparencyChessboardBlankColor(chessboardOptions.getBlackColor());
            ImageEditorUI.this.imageComponent.setGridLineZoomFactor(gridOptions.getLineZoomFactor());
            ImageEditorUI.this.imageComponent.setGridLineSpan(gridOptions.getLineSpan());
            ImageEditorUI.this.imageComponent.setGridLineColor(gridOptions.getLineColor());
        }
    }

    private static class ImageTransferable
    implements Transferable {
        private final BufferedImage myImage;

        public ImageTransferable(@NotNull BufferedImage image) {
            if (image == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ImageEditorUI.IMAGE_PANEL, "org/intellij/images/editor/impl/ImageEditorUI$ImageTransferable", "<init>"));
            }
            this.myImage = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DataFlavor.imageFlavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.myImage;
        }
    }

    private static final class EditorMouseAdapter
    extends PopupHandler {
        private EditorMouseAdapter() {
        }

        public void invokePopup(Component comp, int x, int y) {
            ActionManager actionManager = ActionManager.getInstance();
            ActionGroup actionGroup = (ActionGroup)actionManager.getAction("Images.EditorPopupMenu");
            ActionPopupMenu menu = actionManager.createActionPopupMenu("Images.Editor", actionGroup);
            JPopupMenu popupMenu = menu.getComponent();
            popupMenu.pack();
            popupMenu.show(comp, x, y);
        }
    }

    private class FocusRequester
    extends MouseAdapter {
        private FocusRequester() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/images/editor/impl/ImageEditorUI$FocusRequester", "mousePressed"));
            }
            ImageEditorUI.this.requestFocus();
        }
    }

    private class DocumentChangeListener
    implements ChangeListener {
        private DocumentChangeListener() {
        }

        @Override
        public void stateChanged(@NotNull ChangeEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/images/editor/impl/ImageEditorUI$DocumentChangeListener", "stateChanged"));
            }
            ImageDocument document = ImageEditorUI.this.imageComponent.getDocument();
            BufferedImage value = document.getValue();
            CardLayout layout = (CardLayout)ImageEditorUI.this.contentPanel.getLayout();
            layout.show(ImageEditorUI.this.contentPanel, value != null ? ImageEditorUI.IMAGE_PANEL : ImageEditorUI.ERROR_PANEL);
            ImageEditorUI.this.updateInfo();
            ImageEditorUI.this.revalidate();
            ImageEditorUI.this.repaint();
        }
    }

    private class ImageZoomModelImpl
    implements ImageZoomModel {
        private boolean myZoomLevelChanged = false;

        private ImageZoomModelImpl() {
        }

        @Override
        public double getZoomFactor() {
            Dimension size = ImageEditorUI.this.imageComponent.getCanvasSize();
            BufferedImage image = ImageEditorUI.this.imageComponent.getDocument().getValue();
            return image != null ? size.getWidth() / (double)image.getWidth() : 0.0;
        }

        @Override
        public void setZoomFactor(double zoomFactor) {
            Dimension size = ImageEditorUI.this.imageComponent.getCanvasSize();
            BufferedImage image = ImageEditorUI.this.imageComponent.getDocument().getValue();
            if (image != null) {
                size.setSize((double)image.getWidth() * zoomFactor, (double)image.getHeight() * zoomFactor);
                ImageEditorUI.this.imageComponent.setCanvasSize(size);
            }
            ImageEditorUI.this.revalidate();
            ImageEditorUI.this.repaint();
            this.myZoomLevelChanged = false;
        }

        private double getMinimumZoomFactor() {
            BufferedImage image = ImageEditorUI.this.imageComponent.getDocument().getValue();
            return image != null ? 1.0 / (double)image.getWidth() : 0.0;
        }

        @Override
        public void zoomOut() {
            double factor = this.getZoomFactor();
            if (factor > 1.0) {
                this.setZoomFactor(factor / 2.0);
            } else {
                double minFactor = this.getMinimumZoomFactor();
                double stepSize = (1.0 - minFactor) / 8.0;
                int step = (int)Math.ceil((1.0 - factor) / stepSize);
                this.setZoomFactor(1.0 - stepSize * (double)(step + 1));
            }
            this.myZoomLevelChanged = true;
        }

        @Override
        public void zoomIn() {
            double factor = this.getZoomFactor();
            if (factor >= 1.0) {
                this.setZoomFactor(factor * 2.0);
            } else {
                double minFactor = this.getMinimumZoomFactor();
                double stepSize = (1.0 - minFactor) / 8.0;
                double step = (1.0 - factor) / stepSize;
                this.setZoomFactor(1.0 - stepSize * (step - 1.0));
            }
            this.myZoomLevelChanged = true;
        }

        @Override
        public boolean canZoomOut() {
            double minFactor;
            double stepSize;
            double factor = this.getZoomFactor();
            double step = Math.ceil((1.0 - factor) / (stepSize = (1.0 - (minFactor = this.getMinimumZoomFactor())) / 8.0));
            return step < 8.0;
        }

        @Override
        public boolean canZoomIn() {
            double zoomFactor = this.getZoomFactor();
            return zoomFactor < 32.0;
        }

        @Override
        public boolean isZoomLevelChanged() {
            return this.myZoomLevelChanged;
        }
    }

    private final class ImageWheelAdapter
    implements MouseWheelListener {
        private ImageWheelAdapter() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Options options = OptionsManager.getInstance().getOptions();
            EditorOptions editorOptions = options.getEditorOptions();
            ZoomOptions zoomOptions = editorOptions.getZoomOptions();
            if (zoomOptions.isWheelZooming() && e.isControlDown()) {
                if (e.getWheelRotation() < 0) {
                    ImageEditorUI.this.zoomModel.zoomOut();
                } else {
                    ImageEditorUI.this.zoomModel.zoomIn();
                }
                e.consume();
            }
        }
    }

    private final class ImageContainerPane
    extends JBLayeredPane {
        private final ImageComponent imageComponent;

        public ImageContainerPane(final ImageComponent imageComponent) {
            this.imageComponent = imageComponent;
            this.add(imageComponent);
            this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, new Magnificator(){

                public Point magnify(double scale, Point at) {
                    Point locationBefore = imageComponent.getLocation();
                    ImageZoomModel model = ImageEditorUI.this.editor != null ? ImageEditorUI.this.editor.getZoomModel() : ImageEditorUI.this.getZoomModel();
                    double factor = model.getZoomFactor();
                    model.setZoomFactor(scale * factor);
                    return new Point((int)((double)(at.x - Math.max(scale > 1.0 ? locationBefore.x : 0, 0)) * scale), (int)((double)(at.y - Math.max(scale > 1.0 ? locationBefore.y : 0, 0)) * scale));
                }
            });
        }

        private void centerComponents() {
            Rectangle bounds = this.getBounds();
            Point point = this.imageComponent.getLocation();
            point.x = (bounds.width - this.imageComponent.getWidth()) / 2;
            point.y = (bounds.height - this.imageComponent.getHeight()) / 2;
            this.imageComponent.setLocation(point);
        }

        public void invalidate() {
            this.centerComponents();
            super.invalidate();
        }

        public Dimension getPreferredSize() {
            return this.imageComponent.getSize();
        }

        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "org/intellij/images/editor/impl/ImageEditorUI$ImageContainerPane", "paintComponent"));
            }
            super.paintComponent(g);
            if (UIUtil.isUnderDarcula()) {
                g.setColor(UIUtil.getControlColor().brighter());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }
}

