/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.google.gson.stream.JsonToken;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.UtilKt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.Base64VLQ;
import org.jetbrains.debugger.sourcemap.CharSequenceIterator;
import org.jetbrains.debugger.sourcemap.GeneratedMappingList;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.NamedEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;
import org.jetbrains.debugger.sourcemap.SourceMappingList;
import org.jetbrains.debugger.sourcemap.SourceResolver;
import org.jetbrains.debugger.sourcemap.UnmappedEntry;
import org.jetbrains.debugger.sourcemap.UnnamedEntry;
import org.jetbrains.io.JsonReaderEx;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"a\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0015\t\u0001\u0002B\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001RB\u0003\u0001\u000b\u0005a\u0011!B\u0001\t!\u0015\t\u0001bB\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\"\u0015\u0001Q!\u0001E\t\u000b\u0005!\u0019!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0011\u0005)\u0011\u0001\"\u0003\u000e<!-QB\u0001G\u00011\u0019I2\u0001#\u0004\u000e\u0003a9\u0011d\u0005E\b\u001bEIQ!\u0003\u0003\n\u0005%\t\u0001$\u0003M\t\u0013\u0019IQ!\u0003\u0002\n\u0003aIA\u0012\u0001M\t\u0013\tI\u0011\u0001g\u0005\u0019\u0011Q\u001b)!\u0004\u000e\u0005\u0003!QQ\u0002B\u0005\u0003\u0013\u0005A\u0012\u0001'\u0006\u001a\u0015!YQ\u0002C\u0005\u0007\u0013\u0015I!!C\u0001\u0019\u00031\u0005\u0001T\u0003M\f3\rAA\"D\u0001\u0019\tE\u001b\u0011\u0001#\u0007U\u0007\u000bi\u0019\u0002B\u0001\t\u001b5\t\u00014D\r\u0004\u00119i\u0011\u0001'\bU\u0007\u000biY\u0006B\u0001\t\u001f5\u0011A\u0012\u0001\r\u00073\rAy\"D\u0001\u0019!e\u0019\u0001\u0012E\u0007\u00021\u0011I2\u0001C\t\u000e\u0003a!\u0011D\u0002E\u0012\u001b\u0011I!!C\u0001\u0019\u0003aU\u0011d\u0005E\b\u001bEIQ!\u0003\u0003\n\u0005%\t\u0001$\u0003M\t\u0013\u0019IQ!\u0003\u0002\n\u0003aIA\u0012\u0001M\t\u0013\tI\u0011\u0001g\u0005\u0019\u0011Q\u001b)!\u0004\u0018\u0005\u0003!\u0011R\"\u0001M\u00133\rA1#D\u0001\u0019\u0013e\u0019\u0001rE\u0007\u00021\u0011I2\u0001\u0003\u000b\u000e\u0003a!\u0011D\u0002E\u0012\u001b\u0011I!!C\u0001\u0019\u0003aU\u0011D\u0003\u0005\f\u001b!Ia!C\u0003\n\u0005%\t\u0001$\u0001G\u00011+A:\"G\u0004\t*5)\u0011BA\u0005\u00021%a\t\u0001'\u0005R\u0007\u0005AQ\u0003VB\u0003\u001b7!\u0011\u0001c\u000b\u000e\u000bA1RC\u0001G\u00011%A\u0012\"G\u0002\t 5\t\u0001\u0004\u0005+\u0004\u00065\rB!\u0001E\u0017\u001b\u0011I!!C\u0001\u0019\u0013aE\u0011d\u0001E\u0010\u001b\u0005A\u0002#\u0007\u0003\t/5\u0011A\u0012\u0001\r\n)\u000e\u0015\u0011S\u0004\u0003D\u0011!\u0001Q\u0002B\u0005\u0003\u0013\u0005A\u0012\u0001'\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0004!\u0011Ak!\u0002\u0012\u0018\u0011\t\u0005\u0002C\u0002\u000e\t%\u0011\u0011\"\u0001\r\u00021\u0003\t6!A\u0003\u0001)\u000e\u0015\u0011\u0003\u0004\u0003AQ\u0006A9!D\u0001\u0019\tE\u001bA!\u0002\u0001\u000e\u0005\u0011%\u0001\"\u0002+\u0004\u0006\u0001"}, strings={"MAPPING_COMPARATOR_BY_GENERATED_POSITION", "Ljava/util/Comparator;", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getMAPPING_COMPARATOR_BY_GENERATED_POSITION", "()Ljava/util/Comparator;", "SourceMapDecoderKt", "MAPPING_COMPARATOR_BY_SOURCE_POSITION", "UNMAPPED", "", "getUNMAPPED", "()I", "decodeSourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "in", "", "sourceResolverFactory", "Lkotlin/Function2;", "", "", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "getMapping", "", "reverseMappingsBySourceUrl", "", "sourceIndex", "([Ljava/util/List;I)Ljava/util/List;", "isSeparator", "", "charIterator", "Lorg/jetbrains/debugger/sourcemap/CharSequenceIterator;", "parseMap", "reader", "Lorg/jetbrains/io/JsonReaderEx;", "line", "column", "mappings", "readMappings", "", "value", "initialLine", "initialColumn", "names", "(Ljava/lang/String;IILjava/util/List;[Ljava/util/List;Ljava/util/List;)V", "readSourcePath", "kotlin.jvm.PlatformType", "readSources", "sourceRootUrl"}, moduleName="script-debugger-backend")
public final class SourceMapDecoderKt {
    private static final Comparator<MappingEntry> MAPPING_COMPARATOR_BY_SOURCE_POSITION = MAPPING_COMPARATOR_BY_SOURCE_POSITION.1.INSTANCE;
    @NotNull
    private static final Comparator<MappingEntry> MAPPING_COMPARATOR_BY_GENERATED_POSITION = MAPPING_COMPARATOR_BY_GENERATED_POSITION.1.INSTANCE;
    public static final int UNMAPPED = -1;

    @NotNull
    public static final Comparator<MappingEntry> getMAPPING_COMPARATOR_BY_GENERATED_POSITION() {
        return MAPPING_COMPARATOR_BY_GENERATED_POSITION;
    }

    public static final int getUNMAPPED() {
        return UNMAPPED;
    }

    @Nullable
    public static final SourceMap decodeSourceMap(@NotNull CharSequence in, @NotNull Function2<? super List<String>, ? super List<String>, SourceResolver> sourceResolverFactory) {
        Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
        Intrinsics.checkParameterIsNotNull(sourceResolverFactory, (String)"sourceResolverFactory");
        if (StringsKt.isEmpty((CharSequence)in)) {
            throw (Throwable)new IOException("source map contents cannot be empty");
        }
        JsonReaderEx reader = new JsonReaderEx(in);
        reader.setLenient(true);
        return SourceMapDecoderKt.parseMap(reader, 0, 0, new ArrayList(), sourceResolverFactory);
    }

    /*
     * Unable to fully structure code
     */
    private static final SourceMap parseMap(JsonReaderEx reader, int line, int column, List<MappingEntry> mappings, Function2<? super List<String>, ? super List<String>, SourceResolver> sourceResolverFactory) {
        reader.beginObject();
        sourceRoot = null;
        sourcesReader = null;
        names = null;
        encodedMappings = null;
        file = null;
        version = -1;
        sourcesContent = null;
        while (reader.hasNext()) {
            block27: {
                block33: {
                    block31: {
                        block29: {
                            block30: {
                                block32: {
                                    block28: {
                                        v0 = var12_12 = reader.nextName();
                                        if (v0 == null) break block27;
                                        switch (v0.hashCode()) {
                                            case -1111500899: {
                                                if (!var12_12.equals("sourceRoot")) ** break;
                                                break block28;
                                            }
                                            case 194445669: {
                                                if (!var12_12.equals("mappings")) ** break;
                                                break block29;
                                            }
                                            case 104585032: {
                                                if (!var12_12.equals("names")) ** break;
                                                break block30;
                                            }
                                            case 3143036: {
                                                if (!var12_12.equals("file")) ** break;
                                                break block31;
                                            }
                                            case -2021876808: {
                                                if (!var12_12.equals("sources")) ** break;
                                                break block32;
                                            }
                                            case -252243551: {
                                                if (!var12_12.equals("sourcesContent")) ** break;
                                                break block33;
                                            }
                                            case 351608024: {
                                                if (!var12_12.equals("version")) ** break;
                                                break;
                                            }
                                            case 947936814: {
                                                if (!var12_12.equals("sections")) ** break;
                                                throw (Throwable)new IOException("sections is not supported yet");
                                            }
                                        }
                                        version = reader.nextInt();
                                        continue;
                                    }
                                    sourceRoot = SourceMapDecoderKt.readSourcePath(reader);
                                    if (sourceRoot == null) continue;
                                    sourceRoot = UriUtil.trimTrailingSlashes(sourceRoot);
                                    continue;
                                }
                                sourcesReader = reader.subReader();
                                reader.skipValue();
                                continue;
                            }
                            reader.beginArray();
                            if (reader.hasNext()) {
                                names = new ArrayList<E>();
                                do {
                                    if (Intrinsics.areEqual((Object)reader.peek(), (Object)JsonToken.BEGIN_OBJECT)) {
                                        reader.skipValue();
                                        ((ArrayList)names).add("POLYMER UNKNOWN NAME");
                                        continue;
                                    }
                                    ((ArrayList)names).add(reader.nextString(true));
                                } while (reader.hasNext());
                            } else {
                                names = CollectionsKt.emptyList();
                            }
                            reader.endArray();
                            continue;
                        }
                        encodedMappings = reader.nextString();
                        continue;
                    }
                    file = reader.nextString();
                    continue;
                }
                reader.beginArray();
                if (Intrinsics.areEqual((Object)reader.peek(), (Object)JsonToken.END_ARRAY) ^ true) {
                    sourcesContent = (List)new SmartList();
                    do {
                        if (Intrinsics.areEqual((Object)reader.peek(), (Object)JsonToken.STRING)) {
                            v1 = StringUtilRt.convertLineSeparators((String)reader.nextString());
                            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"StringUtilRt.convertLine\u2026tors(reader.nextString())");
                            sourcesContent.add(v1);
                            continue;
                        }
                        reader.skipValue();
                    } while (reader.hasNext());
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.close();
        if (StringsKt.isNullOrEmpty((CharSequence)encodedMappings)) {
            return null;
        }
        if (version != 3) {
            throw (Throwable)new IOException("Unsupported sourcemap version: " + version);
        }
        if (sourcesReader == null) {
            throw (Throwable)new IOException("sources is not specified");
        }
        sources = SourceMapDecoderKt.readSources(sourcesReader, sourceRoot);
        if (sources.isEmpty()) {
            return null;
        }
        reverseMappingsBySourceUrl = new List[sources.size()];
        v2 = encodedMappings;
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        SourceMapDecoderKt.readMappings(v2, line, column, mappings, reverseMappingsBySourceUrl, names);
        var15_14 = ((Object[])reverseMappingsBySourceUrl).length;
        result$iv = new MappingList[size$iv];
        var17_16 = false;
        var18_17 = size$iv - true;
        if (var17_16 <= var18_17) {
            do {
                var19_18 = ++i$iv;
                var24_21 = i$iv;
                var23_20 = result$iv;
                entries = reverseMappingsBySourceUrl[it];
                if (entries == null) {
                    v3 = null;
                } else {
                    CollectionsKt.sortWith((List)entries, SourceMapDecoderKt.MAPPING_COMPARATOR_BY_SOURCE_POSITION);
                    v3 = new SourceMappingList(entries);
                }
                var25_22 = v3;
                var23_20[var24_21] = var25_22;
            } while (i$iv != var18_17);
        }
        sourceToEntries = (MappingList[])((Object[])result$iv);
        return new SourceMap(file, new GeneratedMappingList((List<? extends MappingEntry>)mappings), sourceToEntries, (SourceResolver)sourceResolverFactory.invoke(sources, (Object)sourcesContent), UtilKt.isNullOrEmpty(names) == false);
    }

    private static final String readSourcePath(JsonReaderEx reader) {
        String $receiver$iv = reader.nextString();
        String string = $receiver$iv;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        CharSequence $receiver$iv$iv = string;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $receiver$iv$iv.charAt(index$iv$iv);
            boolean bl = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()));
    }

    private static final void readMappings(String value, int initialLine, int initialColumn, List<MappingEntry> mappings, List<MappingEntry>[] reverseMappingsBySourceUrl, List<String> names) {
        if (StringsKt.isNullOrEmpty((CharSequence)value)) {
            return;
        }
        int line = initialLine;
        int column = initialColumn;
        CharSequenceIterator charIterator = new CharSequenceIterator(value);
        int sourceIndex = 0;
        List<MappingEntry> reverseMappings = SourceMapDecoderKt.getMapping(reverseMappingsBySourceUrl, sourceIndex);
        int sourceLine = 0;
        int sourceColumn = 0;
        int nameIndex = 0;
        while (charIterator.hasNext()) {
            MappingEntry entry;
            if (charIterator.peek$script_debugger_backend() == ',') {
                charIterator.next();
            } else {
                while (charIterator.peek$script_debugger_backend() == ';') {
                    ++line;
                    column = 0;
                    charIterator.next();
                    if (charIterator.hasNext()) continue;
                    return;
                }
            }
            column += Base64VLQ.decode(charIterator);
            if (SourceMapDecoderKt.isSeparator(charIterator)) {
                mappings.add(new UnmappedEntry(line, column));
                continue;
            }
            int sourceIndexDelta = Base64VLQ.decode(charIterator);
            if (sourceIndexDelta != 0) {
                reverseMappings = SourceMapDecoderKt.getMapping(reverseMappingsBySourceUrl, sourceIndex += sourceIndexDelta);
            }
            sourceLine += Base64VLQ.decode(charIterator);
            sourceColumn += Base64VLQ.decode(charIterator);
            if (SourceMapDecoderKt.isSeparator(charIterator)) {
                entry = new UnnamedEntry(line, column, sourceIndex, sourceLine, sourceColumn);
            } else {
                nameIndex += Base64VLQ.decode(charIterator);
                PreconditionsKt.assert((names != null ? 1 : 0) != 0);
                List<String> list = names;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                entry = new NamedEntry(list.get(nameIndex), line, column, sourceIndex, sourceLine, sourceColumn);
            }
            reverseMappings.add(entry);
            mappings.add(entry);
        }
    }

    private static final List<String> readSources(JsonReaderEx reader, String sourceRootUrl) {
        List sources;
        reader.beginArray();
        if (Intrinsics.areEqual((Object)reader.peek(), (Object)JsonToken.END_ARRAY)) {
            sources = CollectionsKt.emptyList();
        } else {
            sources = (List)new SmartList();
            do {
                String sourceUrl = SourceMapDecoderKt.readSourcePath(reader);
                if (!StringsKt.isNullOrEmpty((CharSequence)sourceRootUrl)) {
                    sourceUrl = sourceRootUrl + "/" + sourceUrl;
                }
                ((SmartList)sources).add((Object)sourceUrl);
            } while (reader.hasNext());
        }
        reader.endArray();
        return sources;
    }

    private static final List<MappingEntry> getMapping(List<MappingEntry>[] reverseMappingsBySourceUrl, int sourceIndex) {
        List reverseMappings = reverseMappingsBySourceUrl[sourceIndex];
        if (reverseMappings == null) {
            reverseMappingsBySourceUrl[sourceIndex] = reverseMappings = (List)new ArrayList();
        }
        return reverseMappings;
    }

    private static final boolean isSeparator(CharSequenceIterator charIterator) {
        if (!charIterator.hasNext()) {
            return true;
        }
        char current = charIterator.peek$script_debugger_backend();
        return current == ',' || current == ';';
    }

    @NotNull
    public static final /* synthetic */ Comparator access$getMAPPING_COMPARATOR_BY_SOURCE_POSITION$p() {
        return MAPPING_COMPARATOR_BY_SOURCE_POSITION;
    }
}

