/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.util.Consumer;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.CharsetUtil;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.Decoder;
import org.jetbrains.io.fastCgi.FastCgiDecoder$WhenMappings;
import org.jetbrains.io.fastCgi.FastCgiService;
import org.jetbrains.io.fastCgi.FastCgiServiceKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"U\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001C\u0004\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001\u0003\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005A\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005AY!B\u0001\u0005\u0007\u0011\u0001A\u0002A\r\u00021\u0003IB!\u0003\u0002\n\u0003a\r\u0001$AO\u0002 A\u0005\u00125D\u0005\u0007\u0011\tiA!\u0003\u0002\n\u0003a\u0019\u0001TA\u0005\u0004\u0011\u000fi\u0011\u0001\u0007\u0003R\u0007\u0005AI!\n\u0005\u0005\u0017!QQ\"\u0001M\u000b3\rA1\"D\u0001\u0019\u0018\u0015\nBa\u0003\u0005\r\u001b\ta\t\u0001g\u0001\u001a\u0007!eQ\"\u0001\r\b3\rA1\"D\u0001\u0019\u0018e\u0019\u0001\"D\u0007\u000217)\u0003\u0002B\u0001\t\u001d5\t\u0001TC\r\u0004\u00113i\u0011\u0001G\u0004&\u0019\u0011Q\u0001RD\u0007\u00021+I2\u0001C\u0006\u000e\u0003a]\u0011d\u0001\u0005\u0010\u001b\u0005Ar!K\u0004\u0005\u0003rAQ!D\u0001\u0019\fE\u001b\u0011!\u0002\u0001*\u0015\u0011\t\u0005\u0002\u0003\u0004\u000e\t%\u0011\u0011\"\u0001\r\b1\u001b\t6!A\u0003\u0001S)!\u0011\t\u0003\u0005\u0003\u001b\u0011I!!C\u0001\u0019\u0007a\u0015\u0011kA\u0001\u0006\u0001%:A!\u0011\u000f\t\u00105\t\u00014B)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B9!AQ\"\u0001M\u0006#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001rA\u0007\u00021\u0011\t6!A\u0003\u0001S\u001d!\u0011\t\bE\t\u001b\u0005A\u0012\"U\u0002\u0002\u000b\u0001Is\u0001B!\u001d\u0011'i\u0011\u0001g\u0003R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/io/fastCgi/FastCgiDecoder;", "Lorg/jetbrains/io/Decoder;", "Lorg/jetbrains/io/Decoder$FullMessageConsumer;", "Ljava/lang/Void;", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "responseHandler", "Lorg/jetbrains/io/fastCgi/FastCgiService;", "(Lcom/intellij/util/Consumer;Lorg/jetbrains/io/fastCgi/FastCgiService;)V", "contentLength", "", "dataBuffers", "Lgnu/trove/TIntObjectHashMap;", "Lio/netty/buffer/ByteBuf;", "id", "paddingLength", "state", "Lorg/jetbrains/io/fastCgi/FastCgiDecoder$State;", "type", "channelInactive", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "contentReceived", "buffer", "isCumulateBuffer", "", "decodeHeader", "messageReceived", "input", "ProtocolStatus", "RecordType", "State"}, moduleName="built-in-server")
public final class FastCgiDecoder
extends Decoder
implements Decoder.FullMessageConsumer<Void> {
    private State state;
    private int type;
    private int id;
    private int contentLength;
    private int paddingLength;
    private final TIntObjectHashMap<ByteBuf> dataBuffers;
    private final Consumer<String> errorOutputConsumer;
    private final FastCgiService responseHandler;

    @Override
    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        while (true) {
            switch (FastCgiDecoder$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    ByteBuf buffer;
                    if (this.paddingLength > 0) {
                        if (input.readableBytes() > this.paddingLength) {
                            input.skipBytes(this.paddingLength);
                            this.paddingLength = 0;
                        } else {
                            this.paddingLength -= input.readableBytes();
                            input.skipBytes(input.readableBytes());
                            return;
                        }
                    }
                    if (this.getBufferIfSufficient(input, 8, context) == null) {
                        return;
                    }
                    ByteBuf byteBuf = buffer;
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
                    this.decodeHeader(byteBuf);
                    this.state = State.CONTENT;
                    if (this.contentLength > 0) {
                        this.readContent(input, context, this.contentLength, this);
                    }
                    this.state = State.HEADER;
                    break;
                }
                case 2: {
                    if (this.contentLength > 0) {
                        this.readContent(input, context, this.contentLength, this);
                    }
                    this.state = State.HEADER;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelInactive(@NotNull ChannelHandlerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            if (!this.dataBuffers.isEmpty()) {
                this.dataBuffers.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<ByteBuf>(){

                    public boolean execute(int a, @NotNull ByteBuf buffer) {
                        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
                        try {
                            buffer.release();
                        }
                        catch (Throwable e) {
                            FastCgiServiceKt.getLOG().error(e);
                        }
                        return true;
                    }
                });
                this.dataBuffers.clear();
            }
        }
        finally {
            super.channelInactive(context);
        }
    }

    private final void decodeHeader(ByteBuf buffer) {
        buffer.skipBytes(1);
        this.type = buffer.readUnsignedByte();
        this.id = buffer.readUnsignedShort();
        this.contentLength = buffer.readUnsignedShort();
        this.paddingLength = buffer.readUnsignedByte();
        buffer.skipBytes(1);
    }

    @Override
    @Nullable
    public Void contentReceived(@NotNull ByteBuf buffer, @NotNull ChannelHandlerContext context, boolean isCumulateBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        switch (this.type) {
            case 3: {
                int appStatus = buffer.readInt();
                short protocolStatus = buffer.readUnsignedByte();
                if (appStatus != 0 || protocolStatus != ProtocolStatus.REQUEST_COMPLETE.ordinal()) {
                    FastCgiServiceKt.getLOG().warn("Protocol status " + protocolStatus);
                    this.dataBuffers.remove(this.id);
                    this.responseHandler.responseReceived(this.id, null);
                    break;
                }
                if (protocolStatus != ProtocolStatus.REQUEST_COMPLETE.ordinal()) break;
                this.responseHandler.responseReceived(this.id, (ByteBuf)this.dataBuffers.remove(this.id));
                break;
            }
            case 6: {
                ByteBuf sliced;
                ByteBuf data = (ByteBuf)this.dataBuffers.get(this.id);
                ByteBuf byteBuf = sliced = isCumulateBuffer ? buffer : buffer.slice(buffer.readerIndex(), this.contentLength);
                if (data == null) {
                    this.dataBuffers.put(this.id, (Object)sliced);
                } else if (data instanceof CompositeByteBuf) {
                    ((CompositeByteBuf)data).addComponent(sliced);
                    ((CompositeByteBuf)data).writerIndex(data.writerIndex() + sliced.readableBytes());
                } else {
                    if (sliced instanceof CompositeByteBuf) {
                        data = (ByteBuf)((CompositeByteBuf)sliced).addComponent(0, data);
                        ((CompositeByteBuf)data).writerIndex(data.writerIndex() + data.readableBytes());
                    } else {
                        int newLength = data.readableBytes() + sliced.readableBytes();
                        data = (ByteBuf)context.alloc().compositeBuffer(FastCgiDecoder.access$getDEFAULT_MAX_COMPOSITE_BUFFER_COMPONENTS$p$s-1087880156()).addComponents(new ByteBuf[]{data, sliced});
                        ((CompositeByteBuf)data).writerIndex(data.writerIndex() + newLength);
                    }
                    this.dataBuffers.put(this.id, (Object)data);
                }
                sliced.retain();
                break;
            }
            case 7: {
                try {
                    this.errorOutputConsumer.consume((Object)buffer.toString(buffer.readerIndex(), this.contentLength, CharsetUtil.UTF_8));
                }
                catch (Throwable e) {
                    FastCgiServiceKt.getLOG().error(e);
                }
                break;
            }
            default: {
                FastCgiServiceKt.getLOG().error("Unknown type " + this.type);
            }
        }
        return null;
    }

    public FastCgiDecoder(@NotNull Consumer<String> errorOutputConsumer, @NotNull FastCgiService responseHandler) {
        Intrinsics.checkParameterIsNotNull(errorOutputConsumer, (String)"errorOutputConsumer");
        Intrinsics.checkParameterIsNotNull((Object)responseHandler, (String)"responseHandler");
        this.errorOutputConsumer = errorOutputConsumer;
        this.responseHandler = responseHandler;
        this.state = State.HEADER;
        this.dataBuffers = new TIntObjectHashMap();
    }

    public static final /* synthetic */ int access$getDEFAULT_MAX_COMPOSITE_BUFFER_COMPONENTS$p$s-1087880156() {
        return 1024;
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011!)\u0011\u0001b\u0001\u0005\u0003\u0004a\u0001!\u0007\u0003\n\u0005%\t\u0001\u0004\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005\t\u00141\u0001\u00026\u0003\u0011\rQ'\u0001\u0003\u0003"}, strings={"Lorg/jetbrains/io/fastCgi/FastCgiDecoder$State;", "", "(Ljava/lang/String;I)V", "HEADER", "CONTENT"}, moduleName="built-in-server")
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State HEADER;
        public static final /* enum */ State CONTENT;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[2];
            State[] stateArray2 = stateArray;
            stateArray[0] = HEADER = new State();
            stateArray[1] = CONTENT = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011!)\u0011\u0001\"\u0002\u0005\u0003\u0004a\u0001!\u0007\u0003\n\u0005%\t\u0001\u0004\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005\t$1\u0001B\u0003\u0007U\nA1A\u001b\u0002\t\t)\u0014\u0001\"\u00026\u0003\u0011\u0019\u0001"}, strings={"Lorg/jetbrains/io/fastCgi/FastCgiDecoder$ProtocolStatus;", "", "(Ljava/lang/String;I)V", "REQUEST_COMPLETE", "CANT_MPX_CONN", "OVERLOADED", "UNKNOWN_ROLE"}, moduleName="built-in-server")
    private static final class ProtocolStatus
    extends Enum<ProtocolStatus> {
        public static final /* enum */ ProtocolStatus REQUEST_COMPLETE;
        public static final /* enum */ ProtocolStatus CANT_MPX_CONN;
        public static final /* enum */ ProtocolStatus OVERLOADED;
        public static final /* enum */ ProtocolStatus UNKNOWN_ROLE;
        private static final /* synthetic */ ProtocolStatus[] $VALUES;

        static {
            ProtocolStatus[] protocolStatusArray = new ProtocolStatus[4];
            ProtocolStatus[] protocolStatusArray2 = protocolStatusArray;
            protocolStatusArray[0] = REQUEST_COMPLETE = new ProtocolStatus();
            protocolStatusArray[1] = CANT_MPX_CONN = new ProtocolStatus();
            protocolStatusArray[2] = OVERLOADED = new ProtocolStatus();
            protocolStatusArray[3] = UNKNOWN_ROLE = new ProtocolStatus();
            $VALUES = protocolStatusArray;
        }

        public static ProtocolStatus[] values() {
            return (ProtocolStatus[])$VALUES.clone();
        }

        public static ProtocolStatus valueOf(String string) {
            return Enum.valueOf(ProtocolStatus.class, string);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!!Q!\u0001\u0003\u0004\t\r\fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!+\u0006\u0005\u0007\"\u000b\u00012A\u0007\u00021\t\t6\u0001B\u0003\u0001\u001b\t!)\u0001C\u0002*\u0016\u0011\u0019\u0005*\u0001E\u0004\u001b\u0005A\"!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0003\t\u0007%VAa\u0011%\u0002\u0011\u0013i\u0011\u0001\u0007\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\u000b!\u0019\u0001"}, strings={"Lorg/jetbrains/io/fastCgi/FastCgiDecoder$RecordType;", "", "()V", "END_REQUEST", "", "getEND_REQUEST", "()I", "STDERR", "getSTDERR", "STDOUT", "getSTDOUT"}, moduleName="built-in-server")
    public static final class RecordType {
        public static final int END_REQUEST = 3;
        public static final int STDOUT = 6;
        public static final int STDERR = 7;
        public static final RecordType INSTANCE;
        public static final RecordType INSTANCE$;

        public final int getEND_REQUEST() {
            return END_REQUEST;
        }

        public final int getSTDOUT() {
            return STDOUT;
        }

        public final int getSTDERR() {
            return STDERR;
        }

        private RecordType() {
            INSTANCE = this;
            INSTANCE$ = this;
            END_REQUEST = 3;
            STDOUT = 6;
            STDERR = 7;
        }

        static {
            new RecordType();
        }
    }
}

