/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FxmlDataExternalizer
implements DataExternalizer<Set<String>> {
    public void save(@NotNull DataOutput out, Set<String> value) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/plugins/javaFX/FxmlDataExternalizer", "save"));
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
        for (String s : value) {
            IOUtil.writeUTF((DataOutput)out, (String)s);
        }
    }

    public Set<String> read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/plugins/javaFX/FxmlDataExternalizer", "read"));
        }
        int size = DataInputOutputUtil.readINT((DataInput)in);
        HashSet<String> result = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            String s = IOUtil.readUTF((DataInput)in);
            result.add(s);
        }
        return result;
    }
}

