/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.FxmlReferencesContributor;

class ImportReferenceProvider
extends PsiReferenceProvider {
    ImportReferenceProvider() {
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        ASTNode importNode;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/ImportReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/refs/ImportReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof XmlProcessingInstruction && (importNode = element.getNode().findChildByType(XmlTokenType.XML_TAG_CHARACTERS)) != null) {
            PsiElement importInstr = importNode.getPsi();
            String instructionTarget = JavaFxPsiUtil.getInstructionTarget("import", (XmlProcessingInstruction)element);
            if (instructionTarget != null && instructionTarget.equals(importInstr.getText())) {
                Object[] references = FxmlReferencesContributor.CLASS_REFERENCE_PROVIDER.getReferencesByString(instructionTarget, element, importInstr.getStartOffsetInParent());
                if (instructionTarget.endsWith(".*")) {
                    PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.remove((Object[])references, (int)(references.length - 1));
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/ImportReferenceProvider", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (references == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/ImportReferenceProvider", "getReferencesByElement"));
                }
                return references;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/ImportReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

