/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.DataMerger;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NodeUtils;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceSet;
import com.android.ide.common.res2.ValueResourceParser2;
import com.android.resources.ResourceType;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceMerger
extends DataMerger<ResourceItem, ResourceFile, ResourceSet> {
    private static final String NODE_MERGED_ITEMS = "mergedItems";
    protected final Map<String, Map<String, ResourceItem>> mMergedItems = Maps.newHashMap();

    @Override
    protected ResourceSet createFromXml(Node node) throws MergingException {
        ResourceSet set = new ResourceSet("");
        return (ResourceSet)set.createFromXml(node);
    }

    @Override
    protected boolean requiresMerge(@NonNull String dataItemKey) {
        return dataItemKey.startsWith("declare-styleable/");
    }

    @Override
    protected void mergeItems(@NonNull String dataItemKey, @NonNull List<ResourceItem> items, @NonNull MergeConsumer<ResourceItem> consumer) throws MergingException {
        boolean touched = false;
        boolean removed = true;
        for (ResourceItem item : items) {
            touched |= item.isTouched();
            removed &= item.isRemoved();
        }
        ResourceItem sourceItem = items.get(0);
        String itemName = sourceItem.getName();
        String qualifier = sourceItem.getQualifiers();
        ResourceItem previouslyWrittenItem = this.getMergedItem(qualifier, itemName);
        try {
            if (touched || previouslyWrittenItem == null && !removed) {
                DocumentBuilder builder = this.mFactory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element declareStyleableNode = document.createElementNS(null, "declare-styleable");
                Attr nameAttr = document.createAttribute("name");
                nameAttr.setValue(itemName);
                declareStyleableNode.getAttributes().setNamedItem(nameAttr);
                HashSet attrs = Sets.newHashSet();
                for (ResourceItem item : items) {
                    Node oldDeclareStyleable;
                    if (item.isRemoved() || (oldDeclareStyleable = item.getValue()) == null) continue;
                    NodeList children = oldDeclareStyleable.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        String name;
                        NamedNodeMap attributes;
                        Node attrNode = children.item(i);
                        if (attrNode.getNodeType() != 1 || "eat-comment".equals(attrNode.getLocalName()) || (nameAttr = (Attr)(attributes = attrNode.getAttributes()).getNamedItemNS(null, "name")) == null || attrs.contains(name = nameAttr.getNodeValue())) continue;
                        attrs.add(name);
                        Node newAttrNode = NodeUtils.duplicateNode(document, attrNode);
                        declareStyleableNode.appendChild(newAttrNode);
                    }
                }
                MergedResourceItem newItem = new MergedResourceItem(itemName, sourceItem.getType(), qualifier, declareStyleableNode);
                if (previouslyWrittenItem == null || !NodeUtils.compareElementNode(newItem.getValue(), previouslyWrittenItem.getValue(), false)) {
                    newItem.setTouched();
                }
                this.addMergedItem(qualifier, newItem);
                consumer.addItem(newItem);
            } else if (previouslyWrittenItem != null) {
                if (removed) {
                    consumer.removeItem(previouslyWrittenItem, null);
                } else {
                    consumer.addItem(previouslyWrittenItem);
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw MergingException.wrapException(e).build();
        }
    }

    @Nullable
    private ResourceItem getMergedItem(@NonNull String qualifiers, @NonNull String name) {
        Map<String, ResourceItem> map = this.mMergedItems.get(qualifiers);
        if (map != null) {
            return map.get(name);
        }
        return null;
    }

    @Override
    @NonNull
    protected String getAdditionalDataTagName() {
        return NODE_MERGED_ITEMS;
    }

    @Override
    protected void loadAdditionalData(@NonNull Node mergedItemsNode, boolean incrementalState) throws MergingException {
        if (!incrementalState) {
            return;
        }
        NodeList configurationList = mergedItemsNode.getChildNodes();
        int n2 = configurationList.getLength();
        for (int j = 0; j < n2; ++j) {
            Attr qualifierAttr;
            Node configuration = configurationList.item(j);
            if (configuration.getNodeType() != 1 || !"configuration".equals(configuration.getLocalName()) || (qualifierAttr = (Attr)configuration.getAttributes().getNamedItem("qualifiers")) == null) continue;
            String qualifier = qualifierAttr.getValue();
            NodeList itemList = configuration.getChildNodes();
            int n3 = itemList.getLength();
            for (int k = 0; k < n3; ++k) {
                MergedResourceItem item;
                Node itemNode = itemList.item(k);
                if (itemNode.getNodeType() != 1 || (item = ResourceMerger.getMergedResourceItem(itemNode, qualifier)) == null) continue;
                this.addMergedItem(qualifier, item);
            }
        }
    }

    @Override
    protected void writeAdditionalData(Document document, Node rootNode) {
        Element mergedItemsNode = document.createElement(this.getAdditionalDataTagName());
        rootNode.appendChild(mergedItemsNode);
        for (String qualifier : this.mMergedItems.keySet()) {
            Map<String, ResourceItem> itemMap = this.mMergedItems.get(qualifier);
            Element qualifierNode = document.createElement("configuration");
            NodeUtils.addAttribute(document, qualifierNode, null, "qualifiers", qualifier);
            mergedItemsNode.appendChild(qualifierNode);
            for (ResourceItem item : itemMap.values()) {
                Node adoptedNode = item.getAdoptedNode(document);
                if (adoptedNode == null) continue;
                qualifierNode.appendChild(adoptedNode);
            }
        }
    }

    private void addMergedItem(@NonNull String qualifier, @NonNull ResourceItem item) {
        HashMap map = this.mMergedItems.get(qualifier);
        if (map == null) {
            map = Maps.newHashMap();
            this.mMergedItems.put(qualifier, map);
        }
        map.put(item.getName(), item);
    }

    static MergedResourceItem getMergedResourceItem(@NonNull Node node, @NonNull String qualifiers) throws MergingException {
        ResourceType type = ValueResourceParser2.getType(node, null);
        String name = ValueResourceParser2.getName(node);
        if (name != null && type != null) {
            return new MergedResourceItem(name, type, qualifiers, node);
        }
        return null;
    }

    private static class MergedResourceItem
    extends ResourceItem {
        @NonNull
        private final String mQualifiers;

        public MergedResourceItem(@NonNull String name, @NonNull ResourceType type, @NonNull String qualifiers, @Nullable Node value) {
            super(name, type, value);
            this.mQualifiers = qualifiers;
        }

        @Override
        @NonNull
        public String getQualifiers() {
            return this.mQualifiers;
        }

        @Override
        @NonNull
        public DataFile.FileType getSourceType() {
            return DataFile.FileType.MULTI;
        }
    }
}

