/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.Map;

public class UniqueNameBuilder<T> {
    public static final char INTERNAL_PATH_DELIMITER = '/';
    private final Map<T, String> myPaths = new THashMap();
    private final String mySeparator;
    private final int myMaxLength;
    private final String myRoot;
    private final Node myRootNode = new Node('\u0000', null);

    public UniqueNameBuilder(String root, String separator, int maxLength) {
        this.myRoot = root;
        this.mySeparator = separator;
        this.myMaxLength = maxLength;
    }

    public boolean contains(T file) {
        return this.myPaths.containsKey(file);
    }

    public void addPath(T key, String value) {
        if (value.startsWith(this.myRoot)) {
            value = value.substring(this.myRoot.length());
        }
        this.myPaths.put(key, value);
        Node current = this.myRootNode;
        for (int i = value.length() - 1; i >= 0; --i) {
            char ch = value.charAt(i);
            Node node = (Node)current.myChildren.get((int)ch);
            if (node == null) {
                node = new Node(ch, current);
                current.myChildren.put((int)ch, (Object)node);
            }
            current = node;
        }
    }

    public String getShortPath(T key) {
        Node firstCharacterOfDirectoryName;
        String path = this.myPaths.get(key);
        if (path == null) {
            return key.toString();
        }
        Node current = this.myRootNode;
        Node firstDirNodeWithSingleChildAfterNodeWithManyChildren = null;
        Node firstDirNode = null;
        boolean searchingForManyChildren = current.myChildren.size() == 1;
        for (int i = path.length() - 1; i >= 0; --i) {
            Node node = (Node)current.myChildren.get((int)path.charAt(i));
            if (node == null) {
                return path;
            }
            if (firstDirNode == null && node.myChar == '/') {
                firstDirNode = node;
            }
            if (searchingForManyChildren && node.myChildren.size() > 1) {
                searchingForManyChildren = false;
            } else if (!searchingForManyChildren && firstDirNodeWithSingleChildAfterNodeWithManyChildren == null && node.myChildren.size() == 1 && node.myChar == '/') {
                firstDirNodeWithSingleChildAfterNodeWithManyChildren = node;
            }
            current = node;
        }
        if (firstDirNodeWithSingleChildAfterNodeWithManyChildren == null) {
            firstDirNodeWithSingleChildAfterNodeWithManyChildren = current;
        }
        boolean skipDirs = firstDirNodeWithSingleChildAfterNodeWithManyChildren != firstDirNode;
        StringBuilder b = new StringBuilder();
        Node n = firstCharacterOfDirectoryName = firstDirNodeWithSingleChildAfterNodeWithManyChildren != current || current.myChar == '/' ? firstDirNodeWithSingleChildAfterNodeWithManyChildren.myParentNode : firstDirNodeWithSingleChildAfterNodeWithManyChildren;
        while (n != this.myRootNode) {
            if (n.myChar == '/') {
                b.append(this.mySeparator);
            } else {
                b.append(n.myChar);
            }
            if (skipDirs && n.myChar == '/' && n != firstDirNode) {
                n = n.myParentNode;
                while (n != firstDirNode) {
                    n = n.myParentNode;
                }
                b.append("\u2026").append(this.mySeparator);
            }
            n = n.myParentNode;
        }
        return b.toString();
    }

    public String getSeparator() {
        return this.mySeparator;
    }

    private static class Node {
        final char myChar;
        final TIntObjectHashMap<Node> myChildren;
        final Node myParentNode;

        Node(char ch, Node parentNode) {
            this.myChar = ch;
            this.myParentNode = parentNode;
            this.myChildren = new TIntObjectHashMap(1);
        }
    }
}

