/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.util.GitFileUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitRepositoryFiles {
    public static final String COMMIT_EDITMSG = "COMMIT_EDITMSG";
    public static final String CONFIG = "config";
    public static final String HEAD = "HEAD";
    public static final String INDEX = "index";
    public static final String INFO = "info";
    public static final String INFO_EXCLUDE = "info/exclude";
    public static final String MERGE_HEAD = "MERGE_HEAD";
    public static final String MERGE_MSG = "MERGE_MSG";
    public static final String ORIG_HEAD = "ORIG_HEAD";
    public static final String REBASE_APPLY = "rebase-apply";
    public static final String REBASE_MERGE = "rebase-merge";
    public static final String PACKED_REFS = "packed-refs";
    public static final String REFS_HEADS = "refs/heads";
    public static final String REFS_REMOTES = "refs/remotes";
    public static final String REFS_TAGS = "refs/tags";
    public static final String SQUASH_MSG = "SQUASH_MSG";
    public static final String GIT_HEAD = ".git" + GitRepositoryFiles.slash("HEAD");
    public static final String GIT_REFS_REMOTES = ".git" + GitRepositoryFiles.slash("refs/remotes");
    public static final String GIT_PACKED_REFS = ".git" + GitRepositoryFiles.slash("packed-refs");
    public static final String GIT_MERGE_HEAD = ".git" + GitRepositoryFiles.slash("MERGE_HEAD");
    public static final String GIT_MERGE_MSG = ".git" + GitRepositoryFiles.slash("MERGE_MSG");
    public static final String GIT_SQUASH_MSG = ".git" + GitRepositoryFiles.slash("SQUASH_MSG");
    public static final String GIT_COMMIT_EDITMSG = ".git" + GitRepositoryFiles.slash("COMMIT_EDITMSG");
    private final String myGitDirPath;
    private final String myConfigFilePath;
    private final String myHeadFilePath;
    private final String myIndexFilePath;
    private final String myMergeHeadPath;
    private final String myOrigHeadPath;
    private final String myRebaseApplyPath;
    private final String myRebaseMergePath;
    private final String myPackedRefsPath;
    private final String myRefsHeadsDirPath;
    private final String myRefsRemotesDirPath;
    private final String myRefsTagsPath;
    private final String myCommitMessagePath;
    private final String myExcludePath;

    public static GitRepositoryFiles getInstance(@NotNull VirtualFile gitDir) {
        if (gitDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitDir", "git4idea/repo/GitRepositoryFiles", "getInstance"));
        }
        return new GitRepositoryFiles(gitDir);
    }

    private GitRepositoryFiles(@NotNull VirtualFile gitDir) {
        if (gitDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitDir", "git4idea/repo/GitRepositoryFiles", "<init>"));
        }
        this.myGitDirPath = GitFileUtils.stripFileProtocolPrefix(gitDir.getPath());
        this.myConfigFilePath = this.myGitDirPath + GitRepositoryFiles.slash(CONFIG);
        this.myHeadFilePath = this.myGitDirPath + GitRepositoryFiles.slash(HEAD);
        this.myIndexFilePath = this.myGitDirPath + GitRepositoryFiles.slash(INDEX);
        this.myMergeHeadPath = this.myGitDirPath + GitRepositoryFiles.slash(MERGE_HEAD);
        this.myOrigHeadPath = this.myGitDirPath + GitRepositoryFiles.slash(ORIG_HEAD);
        this.myCommitMessagePath = this.myGitDirPath + GitRepositoryFiles.slash(COMMIT_EDITMSG);
        this.myRebaseApplyPath = this.myGitDirPath + GitRepositoryFiles.slash(REBASE_APPLY);
        this.myRebaseMergePath = this.myGitDirPath + GitRepositoryFiles.slash(REBASE_MERGE);
        this.myPackedRefsPath = this.myGitDirPath + GitRepositoryFiles.slash(PACKED_REFS);
        this.myRefsHeadsDirPath = this.myGitDirPath + GitRepositoryFiles.slash(REFS_HEADS);
        this.myRefsTagsPath = this.myGitDirPath + GitRepositoryFiles.slash(REFS_TAGS);
        this.myRefsRemotesDirPath = this.myGitDirPath + GitRepositoryFiles.slash(REFS_REMOTES);
        this.myExcludePath = this.myGitDirPath + GitRepositoryFiles.slash(INFO_EXCLUDE);
    }

    @NotNull
    private static String slash(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "git4idea/repo/GitRepositoryFiles", "slash"));
        }
        String string = "/" + s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "slash"));
        }
        return string;
    }

    @NotNull
    static Collection<String> getSubDirRelativePaths() {
        List<String> list = Arrays.asList(GitRepositoryFiles.slash(REFS_HEADS), GitRepositoryFiles.slash(REFS_REMOTES), GitRepositoryFiles.slash(REFS_TAGS), GitRepositoryFiles.slash(INFO));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getSubDirRelativePaths"));
        }
        return list;
    }

    @NotNull
    String getRefsHeadsPath() {
        String string = this.myRefsHeadsDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getRefsHeadsPath"));
        }
        return string;
    }

    @NotNull
    String getRefsRemotesPath() {
        String string = this.myRefsRemotesDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getRefsRemotesPath"));
        }
        return string;
    }

    @NotNull
    String getRefsTagsPath() {
        String string = this.myRefsTagsPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getRefsTagsPath"));
        }
        return string;
    }

    public boolean isConfigFile(String filePath) {
        return filePath.equals(this.myConfigFilePath);
    }

    public boolean isIndexFile(String filePath) {
        return filePath.equals(this.myIndexFilePath);
    }

    public boolean isHeadFile(String file) {
        return file.equals(this.myHeadFilePath);
    }

    public boolean isOrigHeadFile(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/repo/GitRepositoryFiles", "isOrigHeadFile"));
        }
        return file.equals(this.myOrigHeadPath);
    }

    public boolean isBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsHeadsDirPath);
    }

    public boolean isBranchFile(@NotNull String filePath, @NotNull String fullBranchName) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/repo/GitRepositoryFiles", "isBranchFile"));
        }
        if (fullBranchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullBranchName", "git4idea/repo/GitRepositoryFiles", "isBranchFile"));
        }
        return FileUtil.pathsEqual((String)filePath, (String)(this.myGitDirPath + GitRepositoryFiles.slash(fullBranchName)));
    }

    public boolean isRemoteBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsRemotesDirPath);
    }

    public boolean isTagFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/repo/GitRepositoryFiles", "isTagFile"));
        }
        return path.startsWith(this.myRefsTagsPath);
    }

    public boolean isRebaseFile(String path) {
        return path.equals(this.myRebaseApplyPath) || path.equals(this.myRebaseMergePath);
    }

    public boolean isMergeFile(String file) {
        return file.equals(this.myMergeHeadPath);
    }

    public boolean isPackedRefs(String file) {
        return file.equals(this.myPackedRefsPath);
    }

    public boolean isCommitMessageFile(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/repo/GitRepositoryFiles", "isCommitMessageFile"));
        }
        return file.equals(this.myCommitMessagePath);
    }

    public boolean isExclude(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/repo/GitRepositoryFiles", "isExclude"));
        }
        return path.equals(this.myExcludePath);
    }
}

