/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.png.chunks;

import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.png.PngText;
import org.apache.sanselan.formats.png.chunks.PNGTextChunk;

public class PNGChunktEXt
extends PNGTextChunk {
    public final String keyword;
    public final String text;

    public PNGChunktEXt(int length, int chunkType, int crc, byte[] bytes) throws ImageReadException, IOException {
        super(length, chunkType, crc, bytes);
        int index = this.findNull(bytes);
        if (index < 0) {
            throw new ImageReadException("PNG tEXt chunk keyword is not terminated.");
        }
        this.keyword = new String(bytes, 0, index, "ISO-8859-1");
        int textLength = bytes.length - (index + 1);
        this.text = new String(bytes, index + 1, textLength, "ISO-8859-1");
        if (this.getDebug()) {
            System.out.println("Keyword: " + this.keyword);
            System.out.println("Text: " + this.text);
        }
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public PngText getContents() {
        return new PngText.tEXt(this.keyword, this.text);
    }
}

