/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.uiDesigner.LoaderFactory;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.Dimension;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentItemDragObject
implements ComponentDragObject {
    private final ComponentItem myItem;

    public ComponentItemDragObject(@NotNull ComponentItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/uiDesigner/designSurface/ComponentItemDragObject", "<init>"));
        }
        this.myItem = item;
    }

    public ComponentItem getItem() {
        return this.myItem;
    }

    @Override
    public int getComponentCount() {
        return 1;
    }

    @Override
    public boolean isHGrow() {
        return (this.myItem.getDefaultConstraints().getHSizePolicy() & 4) != 0;
    }

    @Override
    public boolean isVGrow() {
        return (this.myItem.getDefaultConstraints().getVSizePolicy() & 4) != 0;
    }

    @Override
    public int getRelativeRow(int componentIndex) {
        return 0;
    }

    @Override
    public int getRelativeCol(int componentIndex) {
        return 0;
    }

    @Override
    public int getRowSpan(int componentIndex) {
        return 1;
    }

    @Override
    public int getColSpan(int componentIndex) {
        return 1;
    }

    @Override
    @Nullable
    public Point getDelta(int componentIndex) {
        return null;
    }

    @Override
    @NotNull
    public Dimension getInitialSize(RadContainer targetContainer) {
        ClassLoader loader = LoaderFactory.getInstance(targetContainer.getProject()).getLoader(targetContainer.getModule());
        Dimension dimension = this.myItem.getInitialSize(targetContainer.getDelegee(), loader);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/designSurface/ComponentItemDragObject", "getInitialSize"));
        }
        return dimension;
    }
}

