/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.impl.ExtensionDomExtender;
import org.jetbrains.idea.devkit.inspections.quickfix.AddWithTagFix;

public class ExtensionPointBeanClassInspection
extends BasicDomElementsInspection<IdeaPlugin> {
    public ExtensionPointBeanClassInspection() {
        super(IdeaPlugin.class, new Class[0]);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        ExtensionPoint extensionPoint;
        if (element instanceof ExtensionPoint && (extensionPoint = (ExtensionPoint)element).getWithElements().isEmpty() && !ExtensionPointBeanClassInspection.collectMissingWithTags(extensionPoint).isEmpty()) {
            holder.createProblem((DomElement)extensionPoint, "<extensionPoint> does not have <with> tags to specify the types of class fields", new LocalQuickFix[]{new AddWithTagFix()});
        }
    }

    public static List<PsiField> collectMissingWithTags(ExtensionPoint element) {
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        PsiClass beanClass = (PsiClass)element.getBeanClass().getValue();
        if (beanClass != null) {
            for (PsiField field : beanClass.getAllFields()) {
                if (!ExtensionDomExtender.isClassField(field.getName()) || ExtensionDomExtender.findWithElement(element.getWithElements(), field) != null) continue;
                result.add(field);
            }
        }
        return result;
    }
}

