/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.SchemeManagerFactoryImplKt;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.ide.actions.ExportSettingsActionKt;
import com.intellij.ide.actions.ExportableItem;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManager;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"9\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\b\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!9Q!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\r\u00035M\u0001\u0002A\u0007\u00021\u0003IB\u0001B\u0001\t\u00035\t\u00014\u0001+\u0004\u00055eA!\u0001E\u0003\u001b\u0005A2!\u0007\u0004\t\b5!\u0011BA\u0005\u00021\u0013AB\u0001V\u0002\u0003\u001b_!\u0011\u0001C\u0003\u000e\u0003a\u0005\u0011d\u0001E\u0006\u001b\u0005Ab!G\u0002\t\u000e5\t\u0001dB\r\u0004\u0011\u001fi\u0011\u0001G\u0002\u001a\u000b!AQb\u0001M\tS\u0005A\u0012\u0002V\u0002\u0003"}, strings={"copyLocalConfig", "", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "CopyAppSettingsToRepositoryKt", "getRoamingType", "Lcom/intellij/openapi/components/RoamingType;", "components", "", "Lcom/intellij/ide/actions/ExportableItem;", "saveDirectory", "parent", "Ljava/io/File;", "parentFileSpec", "", "roamingType", "streamProvider", "Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;", "Lorg/jetbrains/settingsRepository/IcsManager;"}, moduleName="settings-repository")
public final class CopyAppSettingsToRepositoryKt {
    public static final void copyLocalConfig(@NotNull StateStorageManagerImpl storageManager) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        StreamProvider streamProvider = storageManager.getStreamProvider();
        if (streamProvider == null) {
            Intrinsics.throwNpe();
        }
        if (streamProvider == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.settingsRepository.IcsManager.IcsStreamProvider");
        }
        IcsManager.IcsStreamProvider streamProvider2 = (IcsManager.IcsStreamProvider)streamProvider;
        Map fileToComponents = ExportSettingsActionKt.getExportableComponentsMap$default((boolean)true, (boolean)false, (StateStorageManager)((StateStorageManager)storageManager), null, (int)8);
        for (File file : fileToComponents.keySet()) {
            String canonicalPath;
            String absolutePath;
            String string = absolutePath = FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"absolutePath");
            String fileSpec = StateStorageManagerImplKt.removeMacroIfStartsWith((String)storageManager.collapseMacros(string), (String)SchemeManagerFactoryImplKt.getROOT_CONFIG());
            if (Intrinsics.areEqual((Object)fileSpec, (Object)absolutePath) && Intrinsics.areEqual((Object)(canonicalPath = FileUtilRt.toSystemIndependentName((String)file.getCanonicalPath())), (Object)absolutePath) ^ true) {
                String string2 = canonicalPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"canonicalPath");
                fileSpec = StateStorageManagerImplKt.removeMacroIfStartsWith((String)storageManager.collapseMacros(string2), (String)SchemeManagerFactoryImplKt.getROOT_CONFIG());
            }
            Object v = fileToComponents.get(file);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            RoamingType roamingType = CopyAppSettingsToRepositoryKt.getRoamingType((Collection)v);
            if (file.isFile()) {
                byte[] fileBytes = FileUtil.loadFileBytes((File)file);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                streamProvider2.doSave(fileSpec, fileBytes, fileBytes.length, roamingType);
                continue;
            }
            CopyAppSettingsToRepositoryKt.saveDirectory(file, fileSpec, roamingType, streamProvider2);
        }
    }

    public static /* bridge */ /* synthetic */ void copyLocalConfig$default(StateStorageManagerImpl stateStorageManagerImpl, int n) {
        if ((n & 1) != 0) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStateStorageManager();
            if (stateStorageManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
            }
            stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        }
        CopyAppSettingsToRepositoryKt.copyLocalConfig(stateStorageManagerImpl);
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveDirectory(File parent, String parentFileSpec, RoamingType roamingType, IcsManager.IcsStreamProvider streamProvider) {
        Unit unit;
        File[] fileArray = parent.listFiles();
        if (fileArray != null) {
            void $receiver$iv;
            File[] fileArray2 = fileArray;
            File[] it = (File[])$receiver$iv;
            for (int i = 0; i < it.length; ++i) {
                File file = it[i];
                String childFileSpec = parentFileSpec + "/" + file.getName();
                if (file.isFile()) {
                    byte[] fileBytes = FileUtil.loadFileBytes((File)file);
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                    streamProvider.doSave(childFileSpec, fileBytes, fileBytes.length, roamingType);
                    continue;
                }
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                CopyAppSettingsToRepositoryKt.saveDirectory(file2, childFileSpec, roamingType, streamProvider);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    private static final RoamingType getRoamingType(Collection<ExportableItem> components) {
        for (ExportableItem component : components) {
            if (!(component instanceof ExportableItem)) continue;
            return component.getRoamingType();
        }
        return RoamingType.DEFAULT;
    }
}

