/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.util.SmartList;
import java.io.File;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.ReadonlySource;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t!\u0015\tA\"A\u0003\u0002\t\r)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005a\u0001!G\u0001\u0019\u0002\u0005V\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!C\u0002\t\u00055\t\u0001TA)\u0004\u0003!\u0019QE\u0003E\b\u001b\u0005A\u0002\"\u0007\u0004\t\u00125!\u0011BA\u0005\u00021%AB!\n\u0005\u0005\b!MQ\"\u0001M\u00033\rA!\"D\u0001\u0019\u0013%ZA!\u0011\u000f\t\b5)\u0011BA\u0005\u00021\u0013a\t\u0001\u0007\u0003R\u0007\u0005)\u0001!K\u0007\u0005\u0007\"AQ!\u0004\u0003\n\u0005%\t\u0001\u0014\u0002\r\u00059\r\n6aA\u0007\u0003\t\u0017Aa!\u000b\u0006\u0005\u0007\"A!!D\u0001\u0019\u0006E\u001bA!\u0002\u0001\u000e\u0005\u00115\u0001bB\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0007\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/settingsRepository/ReadOnlySourcesManager;", "", "settings", "Lorg/jetbrains/settingsRepository/IcsSettings;", "rootDir", "Ljava/io/File;", "(Lorg/jetbrains/settingsRepository/IcsSettings;Ljava/io/File;)V", "_repositories", "", "Lorg/eclipse/jgit/lib/Repository;", "repositories", "getRepositories", "()Ljava/util/List;", "getRootDir", "()Ljava/io/File;", "setSources", "", "sources", "Lorg/jetbrains/settingsRepository/ReadonlySource;", "sourceToDir", "source"}, moduleName="settings-repository")
public final class ReadOnlySourcesManager {
    private List<? extends Repository> _repositories;
    private final IcsSettings settings;
    @NotNull
    private final File rootDir;

    @NotNull
    public final List<Repository> getRepositories() {
        List r = this._repositories;
        if (r == null) {
            if (this.settings.getReadOnlySources().isEmpty()) {
                r = CollectionsKt.emptyList();
            } else {
                r = (List)new SmartList();
                for (ReadonlySource source : this.settings.getReadOnlySources()) {
                    try {
                        String path;
                        if (source.getPath() == null) {
                            continue;
                        }
                        File dir = new File(this.rootDir, path);
                        if (dir.exists()) {
                            ((SmartList)r).add((Object)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setBare()).setGitDir(dir)).build());
                            continue;
                        }
                        IcsManagerKt.getLOG().warn("Skip read-only source " + source.getUrl() + " because dir doesn't exists");
                    }
                    catch (Exception e) {
                        IcsManagerKt.getLOG().error((Throwable)e);
                    }
                }
            }
            this._repositories = r;
        }
        return r;
    }

    public final void setSources(@NotNull List<ReadonlySource> sources) {
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        this.settings.setReadOnlySources(sources);
        this._repositories = null;
    }

    @NotNull
    public final File sourceToDir(@NotNull ReadonlySource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        String string = source.getPath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return new File(this.rootDir, string);
    }

    @NotNull
    public final File getRootDir() {
        return this.rootDir;
    }

    public ReadOnlySourcesManager(@NotNull IcsSettings settings, @NotNull File rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        this.settings = settings;
        this.rootDir = rootDir;
    }
}

