/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryAddLibraryAction;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;

public abstract class RepositoryUnresolvedReferenceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    @NotNull
    private static String getFQTypeName(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/idea/maven/utils/library/RepositoryUnresolvedReferenceQuickFixProvider", "getFQTypeName"));
        }
        while (ref.getParent() != null && ref.getParent() instanceof PsiJavaCodeReferenceElement) {
            ref = (PsiJavaCodeReferenceElement)ref.getParent();
        }
        String name = ref.getCanonicalText();
        PsiFile file = ref.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryUnresolvedReferenceQuickFixProvider", "getFQTypeName"));
            }
            return string;
        }
        String suffix = "." + name;
        PsiJavaFile javaFile = (PsiJavaFile)file;
        PsiImportList importList = javaFile.getImportList();
        if (importList != null) {
            for (PsiImportStatement importStatement : importList.getImportStatements()) {
                String qualifiedName = importStatement.getQualifiedName();
                if (qualifiedName == null || !qualifiedName.endsWith(suffix) && !qualifiedName.equals(name)) continue;
                String string = qualifiedName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryUnresolvedReferenceQuickFixProvider", "getFQTypeName"));
                }
                return string;
            }
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryUnresolvedReferenceQuickFixProvider", "getFQTypeName"));
        }
        return string;
    }

    protected abstract boolean isSuspectedName(@NotNull String var1);

    @NotNull
    protected abstract RepositoryLibraryDescription getLibraryDescription();

    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/idea/maven/utils/library/RepositoryUnresolvedReferenceQuickFixProvider", "registerFixes"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/maven/utils/library/RepositoryUnresolvedReferenceQuickFixProvider", "registerFixes"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)ref);
        if (module != null && this.isSuspectedName(RepositoryUnresolvedReferenceQuickFixProvider.getFQTypeName(ref))) {
            registrar.register((IntentionAction)new RepositoryAddLibraryAction(module, this.getLibraryDescription()));
        }
    }

    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        if (PsiJavaCodeReferenceElement.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryUnresolvedReferenceQuickFixProvider", "getReferenceClass"));
        }
        return PsiJavaCodeReferenceElement.class;
    }
}

