/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import lombok.ast.Identifier;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;

@Beta
public abstract class JavaParser {
    public static final String TYPE_OBJECT = "java.lang.Object";
    public static final String TYPE_STRING = "java.lang.String";
    public static final String TYPE_INT = "int";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_CHAR = "char";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_NULL = "null";

    public abstract void prepareJavaParse(@NonNull List<JavaContext> var1);

    @Nullable
    public abstract Node parseJava(@NonNull JavaContext var1);

    @NonNull
    public abstract Location getLocation(@NonNull JavaContext var1, @NonNull Node var2);

    @NonNull
    public abstract Location.Handle createLocationHandle(@NonNull JavaContext var1, @NonNull Node var2);

    public void dispose(@NonNull JavaContext context, @NonNull Node compilationUnit) {
    }

    public void dispose() {
    }

    @Nullable
    public abstract ResolvedNode resolve(@NonNull JavaContext var1, @NonNull Node var2);

    @Nullable
    public ResolvedClass findClass(@NonNull JavaContext context, @NonNull String fullyQualifiedName) {
        return null;
    }

    @Nullable
    public abstract TypeDescriptor getType(@NonNull JavaContext var1, @NonNull Node var2);

    public static abstract class ResolvedVariable
    extends ResolvedNode {
        @Override
        @NonNull
        public abstract String getName();

        public abstract boolean matches(@NonNull String var1);

        @NonNull
        public abstract TypeDescriptor getType();
    }

    public static abstract class ResolvedAnnotation
    extends ResolvedNode {
        @Override
        @NonNull
        public abstract String getName();

        public abstract boolean matches(@NonNull String var1);

        @NonNull
        public abstract TypeDescriptor getType();

        @Nullable
        public abstract ResolvedClass getClassType();

        @NonNull
        public abstract List<Value> getValues();

        @Nullable
        public Object getValue(@NonNull String name) {
            for (Value value : this.getValues()) {
                if (!name.equals(value.name)) continue;
                return value.value;
            }
            return null;
        }

        @Nullable
        public Object getValue() {
            return this.getValue("value");
        }

        @Override
        @NonNull
        public Iterable<ResolvedAnnotation> getAnnotations() {
            return Collections.emptyList();
        }

        public static class Value {
            @NonNull
            public final String name;
            @Nullable
            public final Object value;

            public Value(@NonNull String name, @Nullable Object value) {
                this.name = name;
                this.value = value;
            }
        }
    }

    public static abstract class ResolvedField
    extends ResolvedNode {
        @Override
        @NonNull
        public abstract String getName();

        public abstract boolean matches(@NonNull String var1);

        @NonNull
        public abstract TypeDescriptor getType();

        @NonNull
        public abstract ResolvedClass getContainingClass();

        @Nullable
        public abstract Object getValue();

        public String getContainingClassName() {
            return this.getContainingClass().getName();
        }
    }

    public static abstract class ResolvedMethod
    extends ResolvedNode {
        @Override
        @NonNull
        public abstract String getName();

        public abstract boolean matches(@NonNull String var1);

        @NonNull
        public abstract ResolvedClass getContainingClass();

        public abstract int getArgumentCount();

        @NonNull
        public abstract TypeDescriptor getArgumentType(int var1);

        public boolean argumentMatchesType(int index, @NonNull String signature) {
            return this.getArgumentType(index).matchesSignature(signature);
        }

        @Nullable
        public abstract TypeDescriptor getReturnType();

        public boolean isConstructor() {
            return this.getReturnType() == null;
        }

        @NonNull
        public abstract Iterable<ResolvedAnnotation> getParameterAnnotations(int var1);

        @Nullable
        public ResolvedAnnotation getParameterAnnotation(@NonNull String type, int parameterIndex) {
            for (ResolvedAnnotation annotation : this.getParameterAnnotations(parameterIndex)) {
                if (!annotation.getType().matchesSignature(type)) continue;
                return annotation;
            }
            return null;
        }

        @Nullable
        public ResolvedMethod getSuperMethod() {
            ResolvedClass cls = this.getContainingClass().getSuperClass();
            if (cls != null) {
                String methodName = this.getName();
                int argCount = this.getArgumentCount();
                for (ResolvedMethod method : cls.getMethods(methodName, true)) {
                    if (argCount != method.getArgumentCount()) continue;
                    boolean sameTypes = true;
                    for (int arg = 0; arg < argCount; ++arg) {
                        if (method.getArgumentType(arg).equals(this.getArgumentType(arg))) continue;
                        sameTypes = false;
                        break;
                    }
                    if (!sameTypes) continue;
                    return method;
                }
            }
            return null;
        }
    }

    public static abstract class ResolvedClass
    extends ResolvedNode {
        @Override
        @NonNull
        public abstract String getName();

        @NonNull
        public abstract String getSimpleName();

        @NonNull
        public String getPackageName() {
            String name = this.getName();
            String simpleName = this.getSimpleName();
            if (name.length() > simpleName.length() + 1) {
                return name.substring(0, name.length() - simpleName.length() - 1);
            }
            return name;
        }

        public abstract boolean matches(@NonNull String var1);

        @Nullable
        public abstract ResolvedClass getSuperClass();

        @Nullable
        public abstract ResolvedClass getContainingClass();

        public TypeDescriptor getType() {
            return new DefaultTypeDescriptor(this.getName());
        }

        public abstract boolean isSubclassOf(@NonNull String var1, boolean var2);

        @NonNull
        public abstract Iterable<ResolvedMethod> getConstructors();

        @NonNull
        public abstract Iterable<ResolvedMethod> getMethods(boolean var1);

        @NonNull
        public abstract Iterable<ResolvedMethod> getMethods(@NonNull String var1, boolean var2);

        @Nullable
        public abstract ResolvedField getField(@NonNull String var1, boolean var2);
    }

    public static abstract class ResolvedNode {
        @NonNull
        public abstract String getName();

        public abstract String getSignature();

        public abstract int getModifiers();

        public String toString() {
            return this.getSignature();
        }

        @NonNull
        public abstract Iterable<ResolvedAnnotation> getAnnotations();

        @Nullable
        public ResolvedAnnotation getAnnotation(@NonNull String type) {
            for (ResolvedAnnotation annotation : this.getAnnotations()) {
                if (!annotation.getType().matchesSignature(type)) continue;
                return annotation;
            }
            return null;
        }
    }

    public static class DefaultTypeDescriptor
    extends TypeDescriptor {
        private String mName;

        public DefaultTypeDescriptor(String name) {
            this.mName = name;
        }

        @Override
        @NonNull
        public String getName() {
            return this.mName;
        }

        @Override
        @NonNull
        public String getSignature() {
            return this.getName();
        }

        @Override
        public boolean matchesName(@NonNull String name) {
            return this.mName.equals(name);
        }

        @Override
        public boolean matchesSignature(@NonNull String signature) {
            return this.matchesName(signature);
        }

        public String toString() {
            return this.getSignature();
        }

        @Override
        @Nullable
        public ResolvedClass getTypeClass() {
            return null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultTypeDescriptor that = (DefaultTypeDescriptor)o;
            return !(this.mName == null ? that.mName != null : !this.mName.equals(that.mName));
        }

        public int hashCode() {
            return this.mName != null ? this.mName.hashCode() : 0;
        }
    }

    public static abstract class TypeDescriptor {
        @NonNull
        public abstract String getName();

        @NonNull
        public abstract String getSignature();

        public abstract boolean matchesName(@NonNull String var1);

        public abstract boolean matchesSignature(@NonNull String var1);

        @NonNull
        public TypeReference getNode() {
            TypeReference typeReference = new TypeReference();
            StrictListAccessor parts = typeReference.astParts();
            for (String part : Splitter.on((char)'.').split((CharSequence)this.getName())) {
                Identifier identifier = Identifier.of((String)part);
                parts.addToEnd((Node[])new TypeReferencePart[]{new TypeReferencePart().astIdentifier(identifier)});
            }
            return typeReference;
        }

        @Nullable
        public abstract ResolvedClass getTypeClass();

        public abstract boolean equals(Object var1);
    }
}

