/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.binary;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;

public class Handle {
    private static final int SIZE = 20;
    @NotNull
    private final byte[] mValue;
    private final int mHashCode;

    public Handle(@NotNull byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/rpclib/binary/Handle", "<init>"));
        }
        this.mValue = new byte[20];
        assert (value.length == 20);
        System.arraycopy(value, 0, this.mValue, 0, 20);
        this.mHashCode = ByteBuffer.wrap(this.mValue).getInt();
    }

    public Handle(@NotNull Decoder d) throws IOException {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/rpclib/binary/Handle", "<init>"));
        }
        this.mValue = new byte[20];
        assert (d.stream().read(this.mValue) == 20);
        this.mHashCode = ByteBuffer.wrap(this.mValue).getInt();
    }

    public void encode(@NotNull Encoder e) throws IOException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/rpclib/binary/Handle", "encode"));
        }
        e.stream().write(this.mValue);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Handle)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return Arrays.equals(this.mValue, ((Handle)other).mValue);
    }

    public String toString() {
        return DatatypeConverter.printHexBinary((byte[])this.mValue).toLowerCase();
    }

    public int hashCode() {
        return this.mHashCode;
    }
}

