/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum ScreenRound implements ResourceEnum
{
    NOTROUND("notround", "Not Round", "Not Round screen"),
    ROUND("round", "Round", "Round screen");

    private final String mValue;
    private final String mShortDisplayValue;
    private final String mLongDisplayValue;

    private ScreenRound(String value, String displayValue, String longDisplayValue) {
        this.mValue = value;
        this.mShortDisplayValue = displayValue;
        this.mLongDisplayValue = longDisplayValue;
    }

    public static ScreenRound getEnum(String value) {
        for (ScreenRound orient : ScreenRound.values()) {
            if (!orient.mValue.equals(value)) continue;
            return orient;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mLongDisplayValue;
    }

    public static int getIndex(ScreenRound orientation) {
        int i = 0;
        for (ScreenRound orient : ScreenRound.values()) {
            if (orient == orientation) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static ScreenRound getByIndex(int index) {
        ScreenRound[] values = ScreenRound.values();
        if (index >= 0 && index < values.length) {
            return values[index];
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return true;
    }
}

