/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;

public class ThemePreviewLayout
extends ViewGroup {
    private final int mMaxColumns;
    private final int mMaxColumnWidth;
    private final int mMinColumnWidth;
    private final int mItemHorizontalMargin;
    private final int mItemVerticalMargin;
    private int mItemWidth;
    private int mItemHeight;
    private int mNumColumns;

    public ThemePreviewLayout(Context context) {
        this(context, null);
    }

    public ThemePreviewLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ThemePreviewLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs == null) {
            this.mMaxColumnWidth = Integer.MAX_VALUE;
            this.mMinColumnWidth = 0;
            this.mMaxColumns = Integer.MAX_VALUE;
            this.mItemHorizontalMargin = 0;
            this.mItemVerticalMargin = 0;
            return;
        }
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        int maxColumnWidth = attrs.getAttributeIntValue(null, "max_column_width", Integer.MAX_VALUE);
        int minColumnWidth = attrs.getAttributeIntValue(null, "min_column_width", 0);
        int itemHorizontalMargin = attrs.getAttributeIntValue(null, "item_horizontal_margin", 0);
        int itemVerticalMargin = attrs.getAttributeIntValue(null, "item_vertical_margin", 0);
        this.mMaxColumnWidth = (int)TypedValue.applyDimension((int)1, (float)maxColumnWidth, (DisplayMetrics)dm);
        this.mMinColumnWidth = (int)TypedValue.applyDimension((int)1, (float)minColumnWidth, (DisplayMetrics)dm);
        this.mItemHorizontalMargin = (int)TypedValue.applyDimension((int)1, (float)itemHorizontalMargin, (DisplayMetrics)dm);
        this.mItemVerticalMargin = (int)TypedValue.applyDimension((int)1, (float)itemVerticalMargin, (DisplayMetrics)dm);
        this.mMaxColumns = attrs.getAttributeIntValue(null, "max_columns", Integer.MAX_VALUE);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int wSize = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.mPaddingLeft - this.mPaddingRight;
        int childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int itemWidth = 0;
        int itemHeight = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View v = this.getChildAt(i);
            if (v.getVisibility() == 8) continue;
            this.measureChild(v, childWidthSpec, childHeightSpec);
            itemWidth = Math.max(itemWidth, v.getMeasuredWidth());
            itemHeight = Math.max(itemHeight, v.getMeasuredHeight());
        }
        itemWidth = Math.min(Math.max(itemWidth, this.mMinColumnWidth), this.mMaxColumnWidth);
        this.mNumColumns = Math.min((int)Math.ceil((double)wSize / (double)itemWidth), this.mMaxColumns);
        int wSizeNeeded = this.mNumColumns * itemWidth + (this.mNumColumns - 1) * this.mItemHorizontalMargin;
        if (wSizeNeeded > wSize && this.mNumColumns > 1) {
            --this.mNumColumns;
        }
        if (this.getChildCount() < this.mNumColumns) {
            this.mNumColumns = this.getChildCount();
        }
        if (this.mNumColumns == 0) {
            this.mNumColumns = 1;
        }
        childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)itemWidth, (int)0x40000000);
        childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)itemHeight, (int)0x40000000);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View v = this.getChildAt(i);
            if (v.getVisibility() == 8) continue;
            this.measureChild(v, childWidthSpec, childHeightSpec);
        }
        int firstColumnItems = this.getChildCount() / this.mNumColumns + (this.getChildCount() % this.mNumColumns > 0 ? 1 : 0);
        int horizontalMarginsTotalWidth = (this.mNumColumns - 1) * this.mItemHorizontalMargin;
        int verticalMarginsTotalHeight = (firstColumnItems - 1) * this.mItemVerticalMargin;
        int totalWidth = this.mNumColumns * itemWidth + horizontalMarginsTotalWidth + this.mPaddingRight + this.mPaddingLeft;
        int totalHeight = firstColumnItems * itemHeight + verticalMarginsTotalHeight + this.mPaddingBottom + this.mPaddingTop;
        this.setMeasuredDimension(ThemePreviewLayout.resolveSize((int)totalWidth, (int)widthMeasureSpec), ThemePreviewLayout.resolveSize((int)totalHeight, (int)heightMeasureSpec));
        this.mItemWidth = itemWidth;
        this.mItemHeight = itemHeight;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int itemsPerColumn = this.getChildCount() / this.mNumColumns;
        int remainderItems = this.getChildCount() % this.mNumColumns;
        int x = this.mPaddingLeft;
        int y = this.mPaddingTop;
        int position = 1;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View v = this.getChildAt(i);
            v.layout(x, y, x + this.mItemWidth, y + this.mItemHeight);
            if (position == itemsPerColumn + (remainderItems > 0 ? 1 : 0)) {
                position = 1;
                --remainderItems;
                x += this.mItemWidth + this.mItemHorizontalMargin;
                y = this.mPaddingTop;
                continue;
            }
            ++position;
            y += this.mItemHeight + this.mItemVerticalMargin;
        }
    }
}

